document.addEventListener("DOMContentLoaded", function() {
    const form = document.getElementById("registerForm");
    const result = document.getElementById("result");

    form.addEventListener("submit", async function(e) {
        e.preventDefault();

        const formData = new FormData(form);
        const data = {};

        for (let [key, value] of formData.entries()) {
            data[key] = value;
        }

        console.log("📤 در حال ارسال داده:", data);

        try {
            const response = await fetch("./controlls/api/users.php", {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify(data)
            });

            console.log("📥 وضعیت پاسخ:", response.status);

            const resData = await response.json();
            console.log("📦 پاسخ سرور:", resData);

            if (resData.success) {
                showAlert("ثبت نام با موققیت انجام شد از فرم لاگین ورود کنید",)
                const username = document.getElementById("usernameTwo").value;
                const password = document.getElementById("enter-password").value;

                document.getElementById("username").value = username;
                document.getElementById("password").value = password;



            } else {
                var message=resData.message;
                console.log("1", message)
                showAlert(message,"error")

            }

        } catch (error) {
            console.error("❌ خطا:", error);
            result.innerHTML = `<p >خطا در ارتباط با سرور!</p>`;
        }
    });
});



document.addEventListener("DOMContentLoaded", function() {
    const form = document.getElementById("loginForm");

    form.addEventListener("submit", async function(e) {
        e.preventDefault();

        const formData = new FormData(form);
        const data = {};
        for (let [key, value] of formData.entries()) {
            data[key] = value;
        }

        try {
            const response = await fetch("controlls/api/login.php", {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify(data)
            });

            // پاسخ رو بخون
            const resultData = await response.json();

            // وضعیت پاسخ رو بررسی کن
            if (!response.ok) {
                console.warn("کد خطا:", response.status);
                showAlert(resultData.message || "خطای ناشناخته!", "error", "result1");
                return;
            }

            // اگر موفق بود
            if (resultData.status === "success" || resultData.success) {
                showAlert(resultData.message, "success", "result1");
                console.log("ورود موفق:", resultData);
                window.location.href = "./";
            } else {
                showAlert(resultData.message || "ورود ناموفق!", "error", "result1");
            }

        } catch (error) {
            console.error("خطا در ارتباط با سرور:", error);
            showAlert("خطا در ارتباط با سرور!", "error", "result1");
        }
    });
});


function showAlert(message, type = "success",element="result") {
    const result = document.getElementById(element);
    result.innerHTML = message;
    result.className = "alert-box";
    if (type === "success") {
        result.classList.add("alert-success");
    } else {
        result.classList.add("alert-error");
    }
    result.classList.add("alert-show");

    setTimeout(() => {
        result.classList.remove("alert-show");
    }, 100000);
}


// function showAlert(message, type = "success") {
//     const result = document.getElementById("result");
//     result.innerHTML = message;
//     result.className = "alert-box"; // ریست کلاس‌ها
//
//     if (type === "success") {
//         result.classList.add("alert-success");
//     } else {
//         console.log("2", message)
//         result.classList.add("alert-error");
//     }
//
//     result.classList.add("alert-show");
//
//     // بعد از چند ثانیه محو بشه
//     setTimeout(() => {
//         result.classList.remove("alert-show");
//     }, 100000);
// }

