function initSlick($wrapper){
    if(typeof $wrapper.slick === "function"){
        if($wrapper.hasClass('slick-initialized')){
            $wrapper.slick('unslick');
        }

        $wrapper.slick({
            slidesToShow: 6,
            slidesToScroll: 1,
            autoplay: true,
            autoplaySpeed: 2000,
            speed: 900,
            infinite: true,
            dots: false,
            arrows: true,
            nextArrow: "#feature-item-wrapper-next",
            prevArrow: "#feature-item-wrapper-prev",
            responsive: [
                { breakpoint: 992, settings: { slidesToShow: 5 } },
                { breakpoint: 768, settings: { slidesToShow: 4 } },
                { breakpoint: 575, settings: { slidesToShow: 3 } },
                { breakpoint: 424, settings: { slidesToShow: 2 } },
                { breakpoint: 359, settings: { slidesToShow: 1 } }
            ]
        });
    } else {
        // اگر Slick هنوز load نشده، دوباره بعد 100ms امتحان کن
        setTimeout(function(){
            initSlick($wrapper);
        }, 100);
    }
}

$(window).on('load', function(){
    const $wrapper = $(".feature-three-item-wrapper");

    $.getJSON("controlls/api/category.php", function(data){
        let html = data.map((item,index)=>{
            const colors = ["bg-yellow-light","bg-danger-light","bg-purple-light","bg-warning-light","bg-success-light"];
            const color = colors[index % colors.length];
            return `
            <div class="feature-item text-center">
                <div class="feature-item__thumb ${color} max-w-260 max-h-260 rounded-[50%] w-full h-full">
                    <a href="shop.php?cat_id=${item.id}" class="w-full h-full flex items-center justify-center">
                        <img src="controlls/uploads/category/${item.image}" alt="${item.title}" style="width:200px;height:200px;object-fit:cover;border-radius:50%;">
                    </a>
                </div>
                <div class="feature-item__content mt-20">
                    <h6 class="text-lg mb-8">
                        <a href="shop.php?cat_id=${item.id}" class="text-inherit">${item.title}</a>
                    </h6>
                    <span>180 Items</span>
                </div>
            </div>`;
        }).join("");

        $wrapper.html(html);

        // الان Slick رو initialize کن
        initSlick($wrapper);
    });
});
