<!doctype html>
<html lang="en" class="color-two font-exo">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>MarketPro - E-commerce HTML5 Tailwind CSS Template</title>
    <link rel="shortcut icon" href="images/favicon.png">
    <script defer="defer" src="views/assets/js/app.bundle.js"></script>
    <link href="views/assets/css/app.min.css" rel="stylesheet">
</head>

<body>
    <div class="preloader fixed inset-0 z-[9999] flex justify-center items-center bg-white"><img
            src="images/preloader.gif" alt="Image"></div>
    <div class="overlay"></div>
    <div class="side-overlay"></div>
    <div
        class="progress-wrap fixed right-[36px] bottom-[36px] h-[46px] w-[46px] leading-[46px] cursor-pointer block rounded-[50px] shadow-inset z-[10000] opacity-0 invisible translate-y-[15px] transition-all duration-200 ease-linear bg-transparent max-lg:right-[24px] max-lg:bottom-[24px] max-lg:h-[40px] max-lg:w-[40px] max-lg:leading-[40px] hover:scale-[1.06] after:absolute after:font-[900] after:text-center after:w-[46px] after:h-[46px] after:leading-[46px] after:text-[18px] after:left-0 after:top-0 after:cursor-pointer after:block after:content-['\e08e'] after:font-phospor after:z-[1] after:transition-all after:duration-200 after:ease-linear after:text-main max-lg:after:h-[40px] max-lg:after:w-[40px] max-lg:after:leading-[40px]">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>
    <form action="#" class="search-box">
        <button type="button"
            class="search-box__close absolute inset-block-start-0 right-0 m-16 w-48 h-48 border border-gray-100 rounded-[50%] flex items-center justify-center text-white hover-text-gray-800 hover-bg-white text-2xl transition-1">
            <i class="ph ph-x"></i></button>
        <div class="container">
            <div class="relative"><input
                    class="form-control block w-full p-[0.375rem_0.75rem] leading-6 text-[#495057] bg-white bg-clip-padding border border-[#ced4da] transition-all duration-150 ease-in-out focus:text-[#495057] focus:bg-white focus:border-main focus:outline-0 focus:shadow-none py-16 px-24 text-xl rounded-[50rem] pe-64 h-[64px]"
                    placeholder="Search for a product or brand">
                <button type="submit"
                    class="w-48 h-48 bg-main-600 rounded-[50%] flex items-center justify-center text-xl text-white absolute top-[50%] translate-y-[-50%] right-0 me-8">
                    <i class="ph ph-magnifying-glass"></i></button>
            </div>
        </div>
    </form>
    <div class="mobile-menu scroll-sm xl:hidden block">
        <button type="button" class="close-button"><i class="ph ph-x"></i></button>
        <div class="mobile-menu__inner"><a href="index.html" class="mobile-menu__logo"><img src="images/logo.png"
                    alt="Logo"></a>
            <div class="mobile-menu__menu">
                <ul class="nav-menu flex items-center nav-menu--mobile">
                    <li class="on-hover-item nav-menu__item has-submenu activePage"><a href="javascript:void(0)"
                            class="nav-menu__link">Home</a>
                        <ul class="on-hover-dropdown common-dropdown nav-submenu scroll-sm">
                            <li class="common-dropdown__item nav-submenu__item activePage"><a href="index.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Home
                                    Grocery</a></li>
                            <li class="common-dropdown__item nav-submenu__item"><a href="index-two.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Home
                                    Electronics</a></li>
                            <li class="common-dropdown__item nav-submenu__item"><a href="index-three.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Home
                                    Fashion</a></li>
                        </ul>
                    </li>
                    <li class="on-hover-item nav-menu__item has-submenu"><a href="javascript:void(0)"
                            class="nav-menu__link">Shop</a>
                        <ul class="on-hover-dropdown common-dropdown nav-submenu scroll-sm">
                            <li class="common-dropdown__item nav-submenu__item"><a href="shop.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Shop</a>
                            </li>
                            <li class="common-dropdown__item nav-submenu__item"><a href="product-details.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Shop
                                    Details</a></li>
                            <li class="common-dropdown__item nav-submenu__item"><a href="product-details-two.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Shop
                                    Details Two</a></li>
                        </ul>
                    </li>
                    <li class="on-hover-item nav-menu__item has-submenu"><span
                            class="badge-notification bg-warning-600 text-white text-sm py-2 px-8 rounded-4">New</span>
                        <a href="javascript:void(0)" class="nav-menu__link">Pages</a>
                        <ul class="on-hover-dropdown common-dropdown nav-submenu scroll-sm">
                            <li class="common-dropdown__item nav-submenu__item"><a href="cart.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Cart</a>
                            </li>
                            <li class="common-dropdown__item nav-submenu__item"><a href="wishlist.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Wishlist</a>
                            </li>
                            <li class="common-dropdown__item nav-submenu__item"><a href="checkout.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Checkout</a>
                            </li>
                            <li class="common-dropdown__item nav-submenu__item"><a href="become-seller.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Become
                                    Seller</a></li>
                            <li class="common-dropdown__item nav-submenu__item"><a href="account.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Account</a>
                            </li>
                        </ul>
                    </li>
                    <li class="on-hover-item nav-menu__item has-submenu"><span
                            class="badge-notification bg-tertiary-600 text-white text-sm py-2 px-8 rounded-4">New</span>
                        <a href="javascript:void(0)" class="nav-menu__link">Vendors</a>
                        <ul class="on-hover-dropdown common-dropdown nav-submenu scroll-sm">
                            <li class="common-dropdown__item nav-submenu__item"><a href="vendor.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Vendors</a>
                            </li>
                            <li class="common-dropdown__item nav-submenu__item"><a href="vendor-details.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Vendor
                                    Details</a></li>
                            <li class="common-dropdown__item nav-submenu__item"><a href="vendor-two.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Vendors
                                    Two</a></li>
                            <li class="common-dropdown__item nav-submenu__item"><a href="vendor-two-details.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Vendors
                                    Two Details</a></li>
                        </ul>
                    </li>
                    <li class="on-hover-item nav-menu__item has-submenu"><a href="javascript:void(0)"
                            class="nav-menu__link">Blog</a>
                        <ul class="on-hover-dropdown common-dropdown nav-submenu scroll-sm">
                            <li class="common-dropdown__item nav-submenu__item"><a href="blog.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Blog</a>
                            </li>
                            <li class="common-dropdown__item nav-submenu__item"><a href="blog-details.html"
                                    class="common-dropdown__link nav-submenu__link hover-bg-neutral-100">Blog
                                    Details</a></li>
                        </ul>
                    </li>
                    <li class="nav-menu__item"><a href="contact.html" class="nav-menu__link">Contact Us</a></li>
                </ul>
            </div>
        </div>
    </div>
    <?php include 'views/header.php' ?>
    <?php include 'views/header2.php' ?>
    <?php
    $breadcrumb = "Product Details";
    $title = "Product Details";
    include 'views/breadcrumb.php' ?>

    <section class="product-details py-80">
        <div class="container container-lg">
            <div class="row g-4">
                <div class="2xl:w-9/12 flex-grow-0 flex-shrink-0 basis-auto">
                    <div class="row g-4">
                        <div class="2xl:w-6/12 flex-grow-0 flex-shrink-0 basis-auto">
                            <div class="product-details__left">
                                <div class="product-details__thumb-slider border border-gray-100 rounded-16">
                                    <div class="">
                                        <div class="product-details__thumb flex items-center justify-center h-full"><img
                                                src="images/product-details-two-thumb1.png" alt="Image"></div>
                                    </div>
                                    <div class="">
                                        <div class="product-details__thumb flex items-center justify-center h-full"><img
                                                src="images/product-details-two-thumb2.png" alt="Image"></div>
                                    </div>
                                    <div class="">
                                        <div class="product-details__thumb flex items-center justify-center h-full"><img
                                                src="images/product-details-two-thumb3.png" alt="Image"></div>
                                    </div>
                                    <div class="">
                                        <div class="product-details__thumb flex items-center justify-center h-full"><img
                                                src="images/product-details-two-thumb1.png" alt="Image"></div>
                                    </div>
                                    <div class="">
                                        <div class="product-details__thumb flex items-center justify-center h-full"><img
                                                src="images/product-details-two-thumb2.png" alt="Image"></div>
                                    </div>
                                </div>
                                <div class="mt-24">
                                    <div class="product-details__images-slider">
                                        <div>
                                            <div
                                                class="max-w-120 max-h-120 h-full flex items-center justify-center border border-gray-100 rounded-16 p-8">
                                                <img src="images/product-details-two-thumb1.png" alt="Image">
                                            </div>
                                        </div>
                                        <div>
                                            <div
                                                class="max-w-120 max-h-120 h-full flex items-center justify-center border border-gray-100 rounded-16 p-8">
                                                <img src="images/product-details-two-thumb2.png" alt="Image">
                                            </div>
                                        </div>
                                        <div>
                                            <div
                                                class="max-w-120 max-h-120 h-full flex items-center justify-center border border-gray-100 rounded-16 p-8">
                                                <img src="images/product-details-two-thumb3.png" alt="Image">
                                            </div>
                                        </div>
                                        <div>
                                            <div
                                                class="max-w-120 max-h-120 h-full flex items-center justify-center border border-gray-100 rounded-16 p-8">
                                                <img src="images/product-details-two-thumb1.png" alt="Image">
                                            </div>
                                        </div>
                                        <div>
                                            <div
                                                class="max-w-120 max-h-120 h-full flex items-center justify-center border border-gray-100 rounded-16 p-8">
                                                <img src="images/product-details-two-thumb2.png" alt="Image">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="2xl:w-6/12 flex-grow-0 flex-shrink-0 basis-auto">
                            <div id="productDetails" class="product-details__content"></div>
                        </div>
                    </div>
                </div>
                <div class="2xl:w-3/12 flex-grow-0 flex-shrink-0 basis-auto">
                    <div class="product-details__sidebar py-40 px-32 border border-gray-100 rounded-16">
                        <div class="mb-32"><label for="delivery"
                                class="h6 activePage mb-8 text-heading font-[600] block">Delivery</label>
                            <div class="flex items-center border border-gray-100 rounded-4 px-16"><span
                                    class="text-xl flex text-main-600"><i class="ph ph-map-pin"></i> </span><select
                                    class="common-input !border-0 px-8 rounded-4" id="delivery">
                                    <option value="1">Maymansign</option>
                                    <option value="1">Khulna</option>
                                    <option value="1">Rajshahi</option>
                                    <option value="1">Rangpur</option>
                                </select></div>
                        </div>
                        <div class="mb-32"><label for="stock" class="text-lg mb-8 text-heading font-[600] block">Total
                                Stock: 21</label> <span class="text-xl flex"><i class="ph ph-location"></i></span>
                            <div class="flex rounded-4 overflow-hidden">
                                <button type="button"
                                    class="quantity__minus flex-shrink-0 h-48 w-48 text-neutral-600 bg-gray-50 flex items-center justify-center hover-bg-main-600 hover-text-white">
                                    <i class="ph ph-minus"></i></button>
                                <input type="number"
                                    class="quantity__input flex-grow border border-gray-100 border-l-0 border-r-0 text-center w-32 px-16"
                                    id="stock" value="1" min="1">
                                <button type="button"
                                    class="quantity__plus flex-shrink-0 h-48 w-48 text-neutral-600 bg-gray-50 flex items-center justify-center hover-bg-main-600 hover-text-white">
                                    <i class="ph ph-plus"></i></button>
                            </div>
                        </div>
                        <div class="mb-32">
                            <div class="flex-between flex-wrap gap-8 border-b border-gray-100 pb-16 mb-16"><span
                                    class="text-gray-500">Price</span>
                                <h6 class="text-lg mb-0">$150.00</h6>
                            </div>
                            <div class="flex-between flex-wrap gap-8"><span class="text-gray-500">Shipping</span>
                                <h6 class="text-lg mb-0">From $10.00</h6>
                            </div>
                        </div>
                        <a href="index.html"
                            class="btn btn-main flex items-center justify-center gap-8 rounded-8 py-16 font-normal mt-48"><i
                                class="ph ph-shopping-cart-simple text-lg"></i> Add To Cart </a><a href="index.html"
                            class="btn btn-outline-main ritu rounded-8 py-16 font-normal mt-16 w-full">Buy
                            Now</a>
                        <div class="mt-32">
                            <div class="px-16 py-8 bg-main-50 rounded-8 flex-between gap-24 mb-14"><span
                                    class="w-32 h-32 bg-white text-main-600 rounded-[50%] flex items-center justify-center text-xl flex-shrink-0"><i
                                        class="ph-fill ph-truck"></i> </span><span class="text-sm text-neutral-600">Ship
                                    from <span class="font-[600]">MarketPro</span></span></div>
                            <div class="px-16 py-8 bg-main-50 rounded-8 flex-between gap-24 mb-0"><span
                                    class="w-32 h-32 bg-white text-main-600 rounded-[50%] flex items-center justify-center text-xl flex-shrink-0"><i
                                        class="ph-fill ph-storefront"></i> </span><span
                                    class="text-sm text-neutral-600">Sold by: <span class="font-[600]">MR Distribution
                                        LLC</span></span>
                            </div>
                        </div>
                        <div class="mt-32">
                            <div class="px-32 py-16 rounded-8 border border-gray-100 flex-between gap-8"><a
                                    href="index.html" class="flex text-main-600 text-28"><i
                                        class="ph-fill ph-chats-teardrop"></i></a> <span
                                    class="h-26 border border-gray-100"></span>
                                <div class="dropdown on-hover-item">
                                    <button class="flex text-main-600 text-28" type="button"><i
                                            class="ph-fill ph-share-network"></i></button>
                                    <div
                                        class="on-hover-dropdown common-dropdown border-0 inset-inline-start-auto right-0">
                                        <ul class="flex items-center gap-16">
                                            <li><a href="https://www.facebook.com"
                                                    class="w-44 h-44 flex items-center justify-center bg-main-100 text-main-600 text-xl rounded-[50%] hover-bg-main-600 hover-text-white"><i
                                                        class="ph-fill ph-facebook-logo"></i></a></li>
                                            <li><a href="https://www.twitter.com"
                                                    class="w-44 h-44 flex items-center justify-center bg-main-100 text-main-600 text-xl rounded-[50%] hover-bg-main-600 hover-text-white"><i
                                                        class="ph-fill ph-twitter-logo"></i></a></li>
                                            <li><a href="https://www.linkedin.com"
                                                    class="w-44 h-44 flex items-center justify-center bg-main-100 text-main-600 text-xl rounded-[50%] hover-bg-main-600 hover-text-white"><i
                                                        class="ph-fill ph-instagram-logo"></i></a></li>
                                            <li><a href="https://www.pinterest.com"
                                                    class="w-44 h-44 flex items-center justify-center bg-main-100 text-main-600 text-xl rounded-[50%] hover-bg-main-600 hover-text-white"><i
                                                        class="ph-fill ph-linkedin-logo"></i></a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="pt-80">
                <div class="product-dContent border rounded-24">
                    <div class="product-dContent__header border-b border-gray-100 flex-between flex-wrap gap-16">
                        <ul class="nav common-tab nav-pills mb-3" id="pills-tab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link bt-tb-btn active" data-target="#pills-description"
                                    id="pills-description-tab" data-bs-toggle="pill" data-bs-target="#pills-description"
                                    type="button" role="tab" aria-controls="pills-description" aria-selected="true">
                                    Description
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link bt-tb-btn" data-target="#pills-reviews" id="pills-reviews-tab"
                                    data-bs-toggle="pill" data-bs-target="#pills-reviews" type="button" role="tab"
                                    aria-controls="pills-reviews" aria-selected="false">Reviews
                                </button>
                            </li>
                        </ul>
                        <a href="index.html"
                            class="btn bg-color-one rounded-16 flex items-center gap-8 text-main-600 hover-bg-main-600 hover-text-white"><img
                                src="images/satisfaction-icon.png" alt="Image"> 100% Satisfaction Guaranteed</a>
                    </div>
                    <div class="product-dContent__box">
                        <div class="tab-content" id="pills-tabContent">
                            <div class="tab-pane bt-tab-pane fade show active" id="pills-description" role="tabpanel"
                                aria-labelledby="pills-description-tab" tabindex="0">
                                <div class="mb-40">
                                    <h6 class="mb-24">Product Description</h6>
                                    <p>Wherever celebrations and good times happen, the LAY'S brand will be there just
                                        as it
                                        has been for more than 75 years. With flavors almost as rich as our history, we
                                        have
                                        a chip or crisp flavor guaranteed to bring a smile on your face.</p>
                                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend
                                        nunc
                                        a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio,
                                        feugiat
                                        eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit
                                        amet
                                        eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur
                                        laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo.
                                        Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit
                                        amet
                                        consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus
                                        commodo vel.</p>
                                    <ul class="list-inside mt-32 ms-16">
                                        <li class="text-gray-400 mb-4">8.0 oz. bag of LAY'S Classic Potato Chips</li>
                                        <li class="text-gray-400 mb-4">Tasty LAY's potato chips are a great snack</li>
                                        <li class="text-gray-400 mb-4">Includes three ingredients: potatoes, oil, and
                                            salt
                                        </li>
                                        <li class="text-gray-400 mb-4">Gluten free product</li>
                                    </ul>
                                    <ul class="mt-32">
                                        <li class="text-gray-400 mb-4">Made in USA</li>
                                        <li class="text-gray-400 mb-4">Ready To Eat.</li>
                                    </ul>
                                </div>
                                <div class="mb-40">
                                    <h6 class="mb-24">Product Specifications</h6>
                                    <ul class="mt-32">
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-heading font-[500]">Product Type: <span
                                                    class="text-gray-500">Chips & Dips</span></span></li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-heading font-[500]">Product Name: <span
                                                    class="text-gray-500">Potato Chips Classic</span></span></li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-heading font-[500]">Brand: <span
                                                    class="text-gray-500">Lay's</span></span></li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-heading font-[500]">FSA Eligible: <span
                                                    class="text-gray-500">No</span></span></li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-heading font-[500]">Size/Count: <span
                                                    class="text-gray-500">8.0oz</span></span>
                                        </li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-heading font-[500]">Item Code: <span
                                                    class="text-gray-500">331539</span></span>
                                        </li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-heading font-[500]">Ingredients: <span
                                                    class="text-gray-500">Potatoes, Vegetable Oil, and
                                                    Salt.</span></span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="mb-40">
                                    <h6 class="mb-24">Nutrition Facts</h6>
                                    <ul class="mt-32">
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-heading font-[500]">Total Fat 10g 13%</span></li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-heading font-[500]">Saturated Fat 1.5g 7%</span></li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-heading font-[500]">Cholesterol 0mg 0%</span></li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-heading font-[500]">Sodium 170mg 7%</span></li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-heading font-[500]">Potassium 350mg 6%</span></li>
                                    </ul>
                                </div>
                                <div class="mb-0">
                                    <h6 class="mb-24">More Details</h6>
                                    <ul class="mt-32">
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span class="text-gray-500">Lunarlon
                                                midsole delivers ultra-plush responsiveness</span>
                                        </li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span
                                                class="text-gray-500">Encapsulated Air-Sole heel unit for lightweight
                                                cushioning</span>
                                        </li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span class="text-gray-500">Colour
                                                Shown: Ale Brown/Black/Goldtone/Ale Brown</span>
                                        </li>
                                        <li class="text-gray-400 mb-14 flex items-center gap-14"><span
                                                class="w-20 h-20 bg-main-50 text-main-600 text-xs flex items-center justify-center rounded-[50%]"><i
                                                    class="ph ph-check"></i> </span><span class="text-gray-500">Style:
                                                805899-202</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="tab-pane bt-tab-pane fade" id="pills-reviews" role="tabpanel"
                                aria-labelledby="pills-reviews-tab" tabindex="0">
                                <div class="row g-4">
                                    <div class="xl:w-6/12 flex-grow-0 flex-shrink-0 basis-auto">
                                        <h6 class="mb-24">Product
                                            Description</h6>
                                        <div class="flex items-start gap-24 pb-44 border-b border-gray-100 mb-44"><img
                                                src="images/comment-img1.png" alt="Image"
                                                class="w-52 h-52 object-fit-cover rounded-[50%] flex-shrink-0">
                                            <div class="flex-grow">
                                                <div class="flex-between items-start gap-8">
                                                    <div class="">
                                                        <h6 class="mb-12 text-md">Nicolas cage</h6>
                                                        <div class="flex items-center gap-8"><span
                                                                class="text-15 font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-15 font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-15 font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-15 font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-15 font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span></div>
                                                    </div>
                                                    <span class="text-gray-800 text-xs">3 Days ago</span>
                                                </div>
                                                <h6 class="mb-14 text-md mt-24">Greate Product</h6>
                                                <p class="text-gray-700">There are many variations of passages of Lorem
                                                    Ipsum available, but the majority have suffered alteration in some
                                                    form,
                                                    by injected humour</p>
                                                <div class="flex items-center gap-20 mt-44">
                                                    <button
                                                        class="flex items-center gap-12 text-gray-700 hover-text-main-600">
                                                        <i class="ph-bold ph-thumbs-up"></i> Like
                                                    </button>
                                                    <a href="#comment-form"
                                                        class="flex items-center gap-12 text-gray-700 hover-text-main-600"><i
                                                            class="ph-bold ph-arrow-bend-up-left"></i> Replay</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="flex items-start gap-24"><img src="images/comment-img1.png"
                                                alt="Image"
                                                class="w-52 h-52 object-fit-cover rounded-[50%] flex-shrink-0">
                                            <div class="flex-grow">
                                                <div class="flex-between items-start gap-8">
                                                    <div class="">
                                                        <h6 class="mb-12 text-md">Nicolas cage</h6>
                                                        <div class="flex items-center gap-8"><span
                                                                class="text-15 font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-15 font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-15 font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-15 font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-15 font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span></div>
                                                    </div>
                                                    <span class="text-gray-800 text-xs">3 Days ago</span>
                                                </div>
                                                <h6 class="mb-14 text-md mt-24">Greate Product</h6>
                                                <p class="text-gray-700">There are many variations of passages of Lorem
                                                    Ipsum available, but the majority have suffered alteration in some
                                                    form,
                                                    by injected humour</p>
                                                <div class="flex items-center gap-20 mt-44">
                                                    <button
                                                        class="flex items-center gap-12 text-gray-700 hover-text-main-600">
                                                        <i class="ph-bold ph-thumbs-up"></i> Like
                                                    </button>
                                                    <a href="#comment-form"
                                                        class="flex items-center gap-12 text-gray-700 hover-text-main-600"><i
                                                            class="ph-bold ph-arrow-bend-up-left"></i> Replay</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mt-56">
                                            <div class="">
                                                <h6 class="mb-24">Write a Review</h6><span
                                                    class="text-heading mb-8">What is it like to Product?</span>
                                                <div class="flex items-center gap-8"><span
                                                        class="text-15 font-[500] text-warning-600 flex"><i
                                                            class="ph-fill ph-star"></i></span> <span
                                                        class="text-15 font-[500] text-warning-600 flex"><i
                                                            class="ph-fill ph-star"></i></span> <span
                                                        class="text-15 font-[500] text-warning-600 flex"><i
                                                            class="ph-fill ph-star"></i></span> <span
                                                        class="text-15 font-[500] text-warning-600 flex"><i
                                                            class="ph-fill ph-star"></i></span> <span
                                                        class="text-15 font-[500] text-warning-600 flex"><i
                                                            class="ph-fill ph-star"></i></span></div>
                                            </div>
                                            <div class="mt-32">
                                                <form action="#">
                                                    <div class="mb-32"><label for="title"
                                                            class="text-neutral-600 mb-8">Review
                                                            Title</label> <input class="common-input rounded-8"
                                                            id="title" placeholder="Great Products"></div>
                                                    <div class="mb-32"><label for="desc"
                                                            class="text-neutral-600 mb-8">Review
                                                            Content</label> <textarea class="common-input rounded-8"
                                                            id="desc">It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using 'Content here, content here', making it look like readable English.</textarea>
                                                    </div>
                                                    <button type="submit"
                                                        class="btn btn-main rounded-[50rem] mt-48">Submit
                                                        Review
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="xl:w-6/12 flex-grow-0 flex-shrink-0 basis-auto">
                                        <div class="ms-xxl-5">
                                            <h6 class="mb-24">Customers Feedback</h6>
                                            <div class="flex flex-wrap gap-44">
                                                <div
                                                    class="border border-gray-100 rounded-8 px-40 py-52 flex items-center justify-center flex-col flex-shrink-0 text-center">
                                                    <h2 class="mb-6 text-main-600">4.8</h2>
                                                    <div class="flex items-center justify-center gap-8"><span
                                                            class="text-15 font-[500] text-warning-600 flex"><i
                                                                class="ph-fill ph-star"></i></span> <span
                                                            class="text-15 font-[500] text-warning-600 flex"><i
                                                                class="ph-fill ph-star"></i></span> <span
                                                            class="text-15 font-[500] text-warning-600 flex"><i
                                                                class="ph-fill ph-star"></i></span> <span
                                                            class="text-15 font-[500] text-warning-600 flex"><i
                                                                class="ph-fill ph-star"></i></span> <span
                                                            class="text-15 font-[500] text-warning-600 flex"><i
                                                                class="ph-fill ph-star"></i></span></div>
                                                    <span class="mt-16 text-gray-500">Average Product Rating</span>
                                                </div>
                                                <div class="border border-gray-100 rounded-8 px-24 py-40 flex-grow">
                                                    <div class="flex items-center gap-8 mb-20"><span
                                                            class="text-gray-900 flex-shrink-0">5</span>
                                                        <div class="progress w-full bg-gray-100 rounded-[50rem] h-8"
                                                            role="progressbar" aria-label="Basic example"
                                                            aria-valuenow="70" aria-valuemin="0" aria-valuemax="100">
                                                            <div class="progress-bar bg-main-600 rounded-[50rem]"
                                                                style="width:70%"></div>
                                                        </div>
                                                        <div class="flex items-center gap-4"><span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span></div>
                                                        <span class="text-gray-900 flex-shrink-0">124</span>
                                                    </div>
                                                    <div class="flex items-center gap-8 mb-20"><span
                                                            class="text-gray-900 flex-shrink-0">4</span>
                                                        <div class="progress w-full bg-gray-100 rounded-[50rem] h-8"
                                                            role="progressbar" aria-label="Basic example"
                                                            aria-valuenow="50" aria-valuemin="0" aria-valuemax="100">
                                                            <div class="progress-bar bg-main-600 rounded-[50rem]"
                                                                style="width:50%"></div>
                                                        </div>
                                                        <div class="flex items-center gap-4"><span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-gray-400 flex"><i
                                                                    class="ph-fill ph-star"></i></span></div>
                                                        <span class="text-gray-900 flex-shrink-0">52</span>
                                                    </div>
                                                    <div class="flex items-center gap-8 mb-20"><span
                                                            class="text-gray-900 flex-shrink-0">3</span>
                                                        <div class="progress w-full bg-gray-100 rounded-[50rem] h-8"
                                                            role="progressbar" aria-label="Basic example"
                                                            aria-valuenow="35" aria-valuemin="0" aria-valuemax="100">
                                                            <div class="progress-bar bg-main-600 rounded-[50rem]"
                                                                style="width:35%"></div>
                                                        </div>
                                                        <div class="flex items-center gap-4"><span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-gray-400 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-gray-400 flex"><i
                                                                    class="ph-fill ph-star"></i></span></div>
                                                        <span class="text-gray-900 flex-shrink-0">12</span>
                                                    </div>
                                                    <div class="flex items-center gap-8 mb-20"><span
                                                            class="text-gray-900 flex-shrink-0">2</span>
                                                        <div class="progress w-full bg-gray-100 rounded-[50rem] h-8"
                                                            role="progressbar" aria-label="Basic example"
                                                            aria-valuenow="20" aria-valuemin="0" aria-valuemax="100">
                                                            <div class="progress-bar bg-main-600 rounded-[50rem]"
                                                                style="width:20%"></div>
                                                        </div>
                                                        <div class="flex items-center gap-4"><span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-gray-400 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-gray-400 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-gray-400 flex"><i
                                                                    class="ph-fill ph-star"></i></span></div>
                                                        <span class="text-gray-900 flex-shrink-0">5</span>
                                                    </div>
                                                    <div class="flex items-center gap-8 mb-0"><span
                                                            class="text-gray-900 flex-shrink-0">1</span>
                                                        <div class="progress w-full bg-gray-100 rounded-[50rem] h-8"
                                                            role="progressbar" aria-label="Basic example"
                                                            aria-valuenow="5" aria-valuemin="0" aria-valuemax="100">
                                                            <div class="progress-bar bg-main-600 rounded-[50rem]"
                                                                style="width:5%"></div>
                                                        </div>
                                                        <div class="flex items-center gap-4"><span
                                                                class="text-xs font-[500] text-warning-600 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-gray-400 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-gray-400 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-gray-400 flex"><i
                                                                    class="ph-fill ph-star"></i></span> <span
                                                                class="text-xs font-[500] text-gray-400 flex"><i
                                                                    class="ph-fill ph-star"></i></span></div>
                                                        <span class="text-gray-900 flex-shrink-0">2</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="new-arrival pb-80">
        <div class="container container-lg">
            <div class="section-heading">
                <div class="flex-between flex-wrap gap-8">
                    <h5 class="mb-0">You Might Also Like</h5>
                    <div class="flex items-center gap-16"><a href="shop.html"
                            class="text-sm font-[500] text-gray-700 hover-text-main-600 hover-text-decoration-underline">All
                            Products</a>
                        <div class="flex items-center gap-8">
                            <button type="button" id="new-arrival-prev"
                                class="slick-prev slick-arrow flex items-center justify-center rounded-[50%] border border-gray-100 hover-border-main-600 text-xl hover-bg-main-600 hover-text-white transition-1">
                                <i class="ph ph-caret-left"></i></button>
                            <button type="button" id="new-arrival-next"
                                class="slick-next slick-arrow flex items-center justify-center rounded-[50%] border border-gray-100 hover-border-main-600 text-xl hover-bg-main-600 hover-text-white transition-1">
                                <i class="ph ph-caret-right"></i></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="new-arrival__slider arrow-style-two">
                <div>
                    <div
                        class="product-card h-full p-8 border border-gray-100 hover-border-main-600 rounded-16 relative transition-2">
                        <a href="product-details.html" class="product-card__thumb flex items-center justify-center"><img
                                src="images/product-img7.png" alt="Image"></a>
                        <div class="product-card__content p-sm-2 w-full">
                            <h6 class="title text-lg font-[600] mt-12 mb-8"><a href="product-details.html"
                                    class="link text-line-2">C-500 Antioxidant Protect
                                    Dietary Supplement</a></h6>
                            <div class="flex items-center gap-4"><span class="text-main-600 text-md flex"><i
                                        class="ph-fill ph-storefront"></i></span> <span class="text-gray-500 text-xs">By
                                    Lucky Supermarket</span>
                            </div>
                            <div class="product-card__content mt-12">
                                <div class="product-card__price mb-8"><span
                                        class="text-heading text-md font-[600]">$14.99 <span
                                            class="text-gray-500 font-normal">/Qty</span> </span><span
                                        class="text-gray-400 text-md font-[600] text-decoration-line-through">$28.99</span>
                                </div>
                                <div class="flex items-center gap-6"><span
                                        class="text-xs font-[700] text-gray-600">4.8</span> <span
                                        class="text-15 font-[700] text-warning-600 flex"><i
                                            class="ph-fill ph-star"></i></span>
                                    <span class="text-xs font-[700] text-gray-600">(17k)</span>
                                </div>
                                <a href="cart.html"
                                    class="product-card__cart btn bg-main-50 text-main-600 hover-bg-main-600 hover-text-white py-11 px-24 rounded-[50rem] flex items-center gap-8 mt-24 w-full justify-center">Add
                                    To Cart <i class="ph ph-shopping-cart"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    <div
                        class="product-card h-full p-8 border border-gray-100 hover-border-main-600 rounded-16 relative transition-2">
                        <span class="product-card__badge bg-danger-600 px-8 py-4 text-sm text-white">Sale 50% </span><a
                            href="product-details.html"
                            class="product-card__thumb flex items-center justify-center"><img
                                src="images/product-img8.png" alt="Image"></a>
                        <div class="product-card__content p-sm-2 w-full">
                            <h6 class="title text-lg font-[600] mt-12 mb-8"><a href="product-details.html"
                                    class="link text-line-2">Marcel's Modern Pantry Almond
                                    Unsweetened</a></h6>
                            <div class="flex items-center gap-4"><span class="text-main-600 text-md flex"><i
                                        class="ph-fill ph-storefront"></i></span> <span class="text-gray-500 text-xs">By
                                    Lucky Supermarket</span>
                            </div>
                            <div class="product-card__content mt-12">
                                <div class="product-card__price mb-8"><span
                                        class="text-heading text-md font-[600]">$14.99 <span
                                            class="text-gray-500 font-normal">/Qty</span> </span><span
                                        class="text-gray-400 text-md font-[600] text-decoration-line-through">$28.99</span>
                                </div>
                                <div class="flex items-center gap-6"><span
                                        class="text-xs font-[700] text-gray-600">4.8</span> <span
                                        class="text-15 font-[700] text-warning-600 flex"><i
                                            class="ph-fill ph-star"></i></span>
                                    <span class="text-xs font-[700] text-gray-600">(17k)</span>
                                </div>
                                <a href="cart.html"
                                    class="product-card__cart btn bg-main-50 text-main-600 hover-bg-main-600 hover-text-white py-11 px-24 rounded-[50rem] flex items-center gap-8 mt-24 w-full justify-center">Add
                                    To Cart <i class="ph ph-shopping-cart"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    <div
                        class="product-card h-full p-8 border border-gray-100 hover-border-main-600 rounded-16 relative transition-2">
                        <span class="product-card__badge bg-danger-600 px-8 py-4 text-sm text-white">Sale 50% </span><a
                            href="product-details.html"
                            class="product-card__thumb flex items-center justify-center"><img
                                src="images/product-img9.png" alt="Image"></a>
                        <div class="product-card__content p-sm-2 w-full">
                            <h6 class="title text-lg font-[600] mt-12 mb-8"><a href="product-details.html"
                                    class="link text-line-2">O Organics Milk, Whole, Vitamin
                                    D</a></h6>
                            <div class="flex items-center gap-4"><span class="text-main-600 text-md flex"><i
                                        class="ph-fill ph-storefront"></i></span> <span class="text-gray-500 text-xs">By
                                    Lucky Supermarket</span>
                            </div>
                            <div class="product-card__content mt-12">
                                <div class="product-card__price mb-8"><span
                                        class="text-heading text-md font-[600]">$14.99 <span
                                            class="text-gray-500 font-normal">/Qty</span> </span><span
                                        class="text-gray-400 text-md font-[600] text-decoration-line-through">$28.99</span>
                                </div>
                                <div class="flex items-center gap-6"><span
                                        class="text-xs font-[700] text-gray-600">4.8</span> <span
                                        class="text-15 font-[700] text-warning-600 flex"><i
                                            class="ph-fill ph-star"></i></span>
                                    <span class="text-xs font-[700] text-gray-600">(17k)</span>
                                </div>
                                <a href="cart.html"
                                    class="product-card__cart btn bg-main-50 text-main-600 hover-bg-main-600 hover-text-white py-11 px-24 rounded-[50rem] flex items-center gap-8 mt-24 w-full justify-center">Add
                                    To Cart <i class="ph ph-shopping-cart"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    <div
                        class="product-card h-full p-8 border border-gray-100 hover-border-main-600 rounded-16 relative transition-2">
                        <span class="product-card__badge bg-info-600 px-8 py-4 text-sm text-white">Best Sale </span><a
                            href="product-details.html"
                            class="product-card__thumb flex items-center justify-center"><img
                                src="images/product-img10.png" alt="Image"></a>
                        <div class="product-card__content p-sm-2 w-full">
                            <h6 class="title text-lg font-[600] mt-12 mb-8"><a href="product-details.html"
                                    class="link text-line-2">Whole Grains and Seeds Organic
                                    Bread</a></h6>
                            <div class="flex items-center gap-4"><span class="text-main-600 text-md flex"><i
                                        class="ph-fill ph-storefront"></i></span> <span class="text-gray-500 text-xs">By
                                    Lucky Supermarket</span>
                            </div>
                            <div class="product-card__content mt-12">
                                <div class="product-card__price mb-8"><span
                                        class="text-heading text-md font-[600]">$14.99 <span
                                            class="text-gray-500 font-normal">/Qty</span> </span><span
                                        class="text-gray-400 text-md font-[600] text-decoration-line-through">$28.99</span>
                                </div>
                                <div class="flex items-center gap-6"><span
                                        class="text-xs font-[700] text-gray-600">4.8</span> <span
                                        class="text-15 font-[700] text-warning-600 flex"><i
                                            class="ph-fill ph-star"></i></span>
                                    <span class="text-xs font-[700] text-gray-600">(17k)</span>
                                </div>
                                <a href="cart.html"
                                    class="product-card__cart btn bg-main-50 text-main-600 hover-bg-main-600 hover-text-white py-11 px-24 rounded-[50rem] flex items-center gap-8 mt-24 w-full justify-center">Add
                                    To Cart <i class="ph ph-shopping-cart"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    <div
                        class="product-card h-full p-8 border border-gray-100 hover-border-main-600 rounded-16 relative transition-2">
                        <a href="product-details.html" class="product-card__thumb flex items-center justify-center"><img
                                src="images/product-img11.png" alt="Image"></a>
                        <div class="product-card__content p-sm-2 w-full">
                            <h6 class="title text-lg font-[600] mt-12 mb-8"><a href="product-details.html"
                                    class="link text-line-2">Lucerne Yogurt, Lowfat,
                                    Strawberry</a></h6>
                            <div class="flex items-center gap-4"><span class="text-main-600 text-md flex"><i
                                        class="ph-fill ph-storefront"></i></span> <span class="text-gray-500 text-xs">By
                                    Lucky Supermarket</span>
                            </div>
                            <div class="product-card__content mt-12">
                                <div class="product-card__price mb-8"><span
                                        class="text-heading text-md font-[600]">$14.99 <span
                                            class="text-gray-500 font-normal">/Qty</span> </span><span
                                        class="text-gray-400 text-md font-[600] text-decoration-line-through">$28.99</span>
                                </div>
                                <div class="flex items-center gap-6"><span
                                        class="text-xs font-[700] text-gray-600">4.8</span> <span
                                        class="text-15 font-[700] text-warning-600 flex"><i
                                            class="ph-fill ph-star"></i></span>
                                    <span class="text-xs font-[700] text-gray-600">(17k)</span>
                                </div>
                                <a href="cart.html"
                                    class="product-card__cart btn bg-main-50 text-main-600 hover-bg-main-600 hover-text-white py-11 px-24 rounded-[50rem] flex items-center gap-8 mt-24 w-full justify-center">Add
                                    To Cart <i class="ph ph-shopping-cart"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    <div
                        class="product-card h-full p-8 border border-gray-100 hover-border-main-600 rounded-16 relative transition-2">
                        <span class="product-card__badge bg-danger-600 px-8 py-4 text-sm text-white">Sale 50% </span><a
                            href="product-details.html"
                            class="product-card__thumb flex items-center justify-center"><img
                                src="images/product-img12.png" alt="Image"></a>
                        <div class="product-card__content p-sm-2 w-full">
                            <h6 class="title text-lg font-[600] mt-12 mb-8"><a href="product-details.html"
                                    class="link text-line-2">Nature Valley Whole Grain Oats
                                    and Honey Protein</a></h6>
                            <div class="flex items-center gap-4"><span class="text-main-600 text-md flex"><i
                                        class="ph-fill ph-storefront"></i></span> <span class="text-gray-500 text-xs">By
                                    Lucky Supermarket</span>
                            </div>
                            <div class="product-card__content mt-12">
                                <div class="product-card__price mb-8"><span
                                        class="text-heading text-md font-[600]">$14.99 <span
                                            class="text-gray-500 font-normal">/Qty</span> </span><span
                                        class="text-gray-400 text-md font-[600] text-decoration-line-through">$28.99</span>
                                </div>
                                <div class="flex items-center gap-6"><span
                                        class="text-xs font-[700] text-gray-600">4.8</span> <span
                                        class="text-15 font-[700] text-warning-600 flex"><i
                                            class="ph-fill ph-star"></i></span>
                                    <span class="text-xs font-[700] text-gray-600">(17k)</span>
                                </div>
                                <a href="cart.html"
                                    class="product-card__cart btn bg-main-50 text-main-600 hover-bg-main-600 hover-text-white py-11 px-24 rounded-[50rem] flex items-center gap-8 mt-24 w-full justify-center">Add
                                    To Cart <i class="ph ph-shopping-cart"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    <div
                        class="product-card h-full p-8 border border-gray-100 hover-border-main-600 rounded-16 relative transition-2">
                        <span class="product-card__badge bg-info-600 px-8 py-4 text-sm text-white">Best Sale </span><a
                            href="product-details.html"
                            class="product-card__thumb flex items-center justify-center"><img
                                src="images/product-img10.png" alt="Image"></a>
                        <div class="product-card__content p-sm-2 w-full">
                            <h6 class="title text-lg font-[600] mt-12 mb-8"><a href="product-details.html"
                                    class="link text-line-2">Whole Grains and Seeds Organic
                                    Bread</a></h6>
                            <div class="flex items-center gap-4"><span class="text-main-600 text-md flex"><i
                                        class="ph-fill ph-storefront"></i></span> <span class="text-gray-500 text-xs">By
                                    Lucky Supermarket</span>
                            </div>
                            <div class="product-card__content mt-12">
                                <div class="product-card__price mb-8"><span
                                        class="text-heading text-md font-[600]">$14.99 <span
                                            class="text-gray-500 font-normal">/Qty</span> </span><span
                                        class="text-gray-400 text-md font-[600] text-decoration-line-through">$28.99</span>
                                </div>
                                <div class="flex items-center gap-6"><span
                                        class="text-xs font-[700] text-gray-600">4.8</span> <span
                                        class="text-15 font-[700] text-warning-600 flex"><i
                                            class="ph-fill ph-star"></i></span>
                                    <span class="text-xs font-[700] text-gray-600">(17k)</span>
                                </div>
                                <a href="cart.html"
                                    class="product-card__cart btn bg-main-50 text-main-600 hover-bg-main-600 hover-text-white py-11 px-24 rounded-[50rem] flex items-center gap-8 mt-24 w-full justify-center">Add
                                    To Cart <i class="ph ph-shopping-cart"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="shipping mb-24" id="shipping">
        <div class="container container-lg">
            <div class="row g-4">
                <div class="custom-2xl:w-3/12 flex-grow-0 flex-shrink-0 basis-auto md:w-6/12">
                    <div
                        class="shipping-item flex items-center gap-16 rounded-16 bg-main-50 hover-bg-main-100 transition-2">
                        <span
                            class="w-56 h-56 flex items-center justify-center rounded-[50%] bg-main-600 text-white text-32 flex-shrink-0"><i
                                class="ph-fill ph-car-profile"></i></span>
                        <div class="">
                            <h6 class="mb-0">Free Shipping</h6><span class="text-sm text-heading">Free shipping all over
                                the US</span>
                        </div>
                    </div>
                </div>
                <div class="custom-2xl:w-3/12 flex-grow-0 flex-shrink-0 basis-auto md:w-6/12">
                    <div
                        class="shipping-item flex items-center gap-16 rounded-16 bg-main-50 hover-bg-main-100 transition-2">
                        <span
                            class="w-56 h-56 flex items-center justify-center rounded-[50%] bg-main-600 text-white text-32 flex-shrink-0"><i
                                class="ph-fill ph-hand-heart"></i></span>
                        <div class="">
                            <h6 class="mb-0">100% Satisfaction</h6><span class="text-sm text-heading">Free shipping all
                                over the US</span>
                        </div>
                    </div>
                </div>
                <div class="custom-2xl:w-3/12 flex-grow-0 flex-shrink-0 basis-auto md:w-6/12">
                    <div
                        class="shipping-item flex items-center gap-16 rounded-16 bg-main-50 hover-bg-main-100 transition-2">
                        <span
                            class="w-56 h-56 flex items-center justify-center rounded-[50%] bg-main-600 text-white text-32 flex-shrink-0"><i
                                class="ph-fill ph-credit-card"></i></span>
                        <div class="">
                            <h6 class="mb-0">Secure Payments</h6><span class="text-sm text-heading">Free shipping all
                                over the US</span>
                        </div>
                    </div>
                </div>
                <div class="custom-2xl:w-3/12 flex-grow-0 flex-shrink-0 basis-auto md:w-6/12">
                    <div
                        class="shipping-item flex items-center gap-16 rounded-16 bg-main-50 hover-bg-main-100 transition-2">
                        <span
                            class="w-56 h-56 flex items-center justify-center rounded-[50%] bg-main-600 text-white text-32 flex-shrink-0"><i
                                class="ph-fill ph-chats"></i></span>
                        <div class="">
                            <h6 class="mb-0">24/7 Support</h6><span class="text-sm text-heading">Free shipping all over
                                the US</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="newsletter">
        <div class="container container-lg">
            <div class="newsletter-box relative rounded-16 flex items-center gap-16 flex-wrap z-[1]"><img
                    src="images/newsletter-bg.png" alt="Image"
                    class="absolute inset-block-start-0 inset-inline-start-0 z-[-1] w-full h-full opacity-6">
                <div class="row items-center">
                    <div class="2xl:w-6/12 flex-grow-0 flex-shrink-0 basis-auto">
                        <div class="">
                            <h1 class="text-white mb-12 wow fadeInUp">Don't Miss Out on Grocery Deals</h1>
                            <p class="text-white h5 mb-0 wow fadeInUp">SING UP FOR THE UPDATE NEWSLETTER</p>
                            <form action="#" class="relative mt-40 wow fadeInUp"><input
                                    class="form-control block w-full p-[0.375rem_0.75rem] text-base leading-6 placeholder:text-[#495057] bg-white bg-clip-padding border border-[#ced4da] transition-all duration-150 ease-in-out focus:text-[#495057] focus:bg-white focus:border-main focus:outline-0 focus:shadow-none common-input !rounded-[50rem] text-white py-22 px-16 pe-144"
                                    placeholder="Your email address...">
                                <button type="submit"
                                    class="btn btn-main-two !rounded-[50rem] !absolute top-[50%] translate-y-[-50%] right-0 mr-[10px]">
                                    Subscribe
                                </button>
                            </form>
                        </div>
                    </div>
                    <div class="2xl:w-6/12 flex-grow-0 flex-shrink-0 basis-auto text-center xl:block hidden"><img
                            src="images/newsletter-img.png" alt="Image" class="wow fadeInUp"></div>
                </div>
            </div>
        </div>
    </div>
    <footer class="footer py-80 overflow-hidden">
        <div class="container container-lg">
            <div class="footer-item-two-wrapper flex items-start flex-wrap">
                <div class="footer-item max-w-275 wow fadeInUp">
                    <div class="footer-item__logo"><a href="index.html"><img src="images/logo-two-black.png"
                                alt="Image"></a></div>
                    <p class="mb-24">Marketpro become the largest computer parts, gaming pc parts, and other IT related
                        products.</p>
                    <div class="flex items-center gap-16 mb-16"><span
                            class="w-32 h-32 flex items-center justify-center rounded-[50%] border border-gray-100 text-main-two-600 text-md flex-shrink-0"><i
                                class="ph-fill ph-phone-call"></i></span> <a href="tel:+00123456789"
                            class="text-md text-gray-900 hover-text-main-600">+00
                            123 456 789</a></div>
                    <div class="flex items-center gap-16 mb-16"><span
                            class="w-32 h-32 flex items-center justify-center rounded-[50%] border border-gray-100 text-main-two-600 text-md flex-shrink-0"><i
                                class="ph-fill ph-envelope"></i></span> <a href="mailto:support24@marketpro.com"
                            class="text-md text-gray-900 hover-text-main-600">support24@marketpro.com</a>
                    </div>
                    <div class="flex items-center gap-16 mb-16"><span
                            class="w-32 h-32 flex items-center justify-center rounded-[50%] border border-gray-100 text-main-two-600 text-md flex-shrink-0"><i
                                class="ph-fill ph-map-pin"></i></span> <span class="text-md text-gray-900">789 Inner
                            Lane, California, USA</span>
                    </div>
                </div>
                <div class="footer-item wow fadeInUp">
                    <h6 class="footer-item__title">About us</h6>
                    <ul class="footer-menu">
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Company
                                Profile</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">All Retail
                                Store</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Merchant
                                Center</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Affiliate</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Contact Us</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Feedback</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Huawei Group</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Rules &
                                Policy</a>
                        </li>
                    </ul>
                </div>
                <div class="footer-item wow fadeInUp">
                    <h6 class="footer-item__title">Customer Support</h6>
                    <ul class="footer-menu">
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Help Center</a>
                        </li>
                        <li class="mb-16"><a href="contact.html" class="text-gray-600 hover-text-main-600">Contact
                                Us</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Gift Card</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Report Abuse</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Submit and
                                Dispute</a></li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Policies &
                                Rules</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Online
                                Shopping</a>
                        </li>
                        <li class=""><a href="shop.html" class="text-gray-600 hover-text-main-600">Redeem Voucher</a>
                        </li>
                    </ul>
                </div>
                <div class="footer-item wow fadeInUp">
                    <h6 class="footer-item__title">My Account</h6>
                    <ul class="footer-menu">
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">My Account</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Order
                                History</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Shoping Cart</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Compare</a></li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Help Ticket</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Wishlist</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Order
                                History</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Product
                                Support</a>
                        </li>
                    </ul>
                </div>
                <div class="footer-item wow fadeInUp">
                    <h6 class="footer-item__title">Information</h6>
                    <ul class="footer-menu">
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Become a
                                Vendor</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Affiliate
                                Program</a></li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Privacy
                                Policy</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Our
                                Suppliers</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Extended
                                Plan</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Extended
                                Plan</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Community</a>
                        </li>
                        <li class="mb-16"><a href="shop.html" class="text-gray-600 hover-text-main-600">Community</a>
                        </li>
                    </ul>
                </div>
                <div class="footer-item wow fadeInUp">
                    <h6 class="">Shop on The Go</h6>
                    <p class="mb-16">Marketpro App is available. Get it now</p>
                    <div class="flex items-center gap-8 my-32"><a href="https://www.apple.com/store" class=""><img
                                src="images/store-img1.png" alt="Image"> </a><a
                            href="https://play.google.com/store/apps?hl=en" class=""><img src="images/store-img2.png"
                                alt="Image"></a></div>
                    <ul class="flex items-center gap-16">
                        <li><a href="https://www.facebook.com"
                                class="w-44 h-44 flex items-center justify-center bg-main-two-50 text-main-two-600 text-xl rounded-8 hover-bg-main-two-600 hover-text-white"><i
                                    class="ph-fill ph-facebook-logo"></i></a></li>
                        <li><a href="https://www.twitter.com"
                                class="w-44 h-44 flex items-center justify-center bg-main-two-50 text-main-two-600 text-xl rounded-8 hover-bg-main-two-600 hover-text-white"><i
                                    class="ph-fill ph-twitter-logo"></i></a></li>
                        <li><a href="https://www.linkedin.com"
                                class="w-44 h-44 flex items-center justify-center bg-main-two-50 text-main-two-600 text-xl rounded-8 hover-bg-main-two-600 hover-text-white"><i
                                    class="ph-fill ph-instagram-logo"></i></a></li>
                        <li><a href="https://www.pinterest.com"
                                class="w-44 h-44 flex items-center justify-center bg-main-two-50 text-main-two-600 text-xl rounded-8 hover-bg-main-two-600 hover-text-white"><i
                                    class="ph-fill ph-linkedin-logo"></i></a></li>
                    </ul>
                </div>
            </div>
        </div>
    </footer>
    <div class="bottom-footer bg-color-one py-8">
        <div class="container container-lg">
            <div class="bottom-footer__inner flex-between flex-wrap gap-16 py-16">
                <p class="bottom-footer__text wow fadeInLeftBig">Marketpro eCommerce &copy; 2024. All Rights
                    Reserved</p>
                <div class="flex items-center gap-8 flex-wrap wow fadeInRightBig"><span class="text-heading text-sm">We
                        Are Accepting</span>
                    <img src="images/payment-method.png" alt="Image">
                </div>
            </div>
        </div>
    </div>
    <script src="views/api/product/product.js"></script>
</body>

</html>