<?php
require_once __DIR__ . '/../functions.php';
class Story {
    private $conn;
    private $apiToken = 'YOUR_API_TOKEN_HERE'; // توکن API

    public function __construct($conn) {
        $this->conn = $conn;
    }

    /**
     * دریافت استوری‌ها با مرتب‌سازی و محدودیت
     */
    public function getStories($limit = 10, $sortLike = 'desc', $sortTime = 'desc') {
        $sortLike = strtolower($sortLike) === 'asc' ? 'ASC' : 'DESC';
        $sortTime = strtolower($sortTime) === 'asc' ? 'ASC' : 'DESC';

        $sql = "SELECT * FROM stories 
                WHERE status='active' AND expires_at > NOW()
                ORDER BY likes_count $sortLike, created_at $sortTime
                LIMIT :limit";

        $stmt = $this->conn->prepare($sql);
        $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
        $stmt->execute();

        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * اضافه کردن استوری جدید
     */
    public function addStory($user_id, $content_type, $content_url, $caption = null) {
        $expires_at = date('Y-m-d H:i:s', strtotime('+24 hours'));

        $sql = "INSERT INTO stories (user_id, content_type, content_url, caption, expires_at)
                VALUES (:user_id, :content_type, :content_url, :caption, :expires_at)";

        $stmt = $this->conn->prepare($sql);
        $stmt->execute([
            ':user_id' => $user_id,
            ':content_type' => $content_type,
            ':content_url' => $content_url,
            ':caption' => $caption,
            ':expires_at' => $expires_at
        ]);

        return $this->conn->lastInsertId();
    }

    /**
     * بروزرسانی استوری
     */
    public function updateStory($id, $data) {
        $fields = [];
        $params = [':id' => $id];

        if (isset($data['content_type'])) {
            $fields[] = "content_type = :content_type";
            $params[':content_type'] = $data['content_type'];
        }

        if (isset($data['content_url'])) {
            $fields[] = "content_url = :content_url";
            $params[':content_url'] = $data['content_url'];
        }

        if (isset($data['caption'])) {
            $fields[] = "caption = :caption";
            $params[':caption'] = $data['caption'];
        }

        if (isset($data['status'])) {
            $fields[] = "status = :status";
            $params[':status'] = $data['status'];
        }

        if (empty($fields)) return false; // هیچ فیلدی برای بروزرسانی نیست

        $sql = "UPDATE stories SET " . implode(", ", $fields) . " WHERE id = :id";
        $stmt = $this->conn->prepare($sql);
        return $stmt->execute($params);
    }

    /**
     * حذف استوری
     */
    public function deleteStory($id) {
        $sql = "DELETE FROM stories WHERE id = :id";
        $stmt = $this->conn->prepare($sql);
        return $stmt->execute([':id' => $id]);
    }

    /**
     * بررسی توکن
     */
    // public function verifyToken($token) {
    //     return $token === $this->apiToken;
    // }
}