<?php
header('Content-Type: application/json');

require_once '../db/functions.php';
require_once '../db/users/User.php';

$user = new User($conn);

$method = $_SERVER['REQUEST_METHOD'];
$id = $_GET['id'] ?? null;
$input = json_decode(file_get_contents('php://input'), true);


switch($method) {
    case 'GET':
        echo json_encode($id ? $user->get($id) : $user->getAll());
        break;

    case 'POST':
        $result = $user->create($input);
        echo json_encode($result, JSON_UNESCAPED_UNICODE);
        break;

    case 'PUT':
        if ($id) {
            $user->update($id, $input);
            echo json_encode(['status' => 'updated']);
        }
        break;

    case 'DELETE':
        if ($id) {
            $user->delete($id);
            echo json_encode(['status' => 'deleted']);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(errorResponse("درخواست نامعتبر است!", 405), JSON_UNESCAPED_UNICODE);

        break;
}