<?php
header('Content-Type: application/json');

require_once '../db/functions.php';
require_once '../db/stories/Story.php';

$storyObj = new Story($conn);

// گرفتن متد HTTP
$method = $_SERVER['REQUEST_METHOD'];
$id = $_GET['id'] ?? null; // برای GET/PUT/DELETE خاص
$input = json_decode(file_get_contents('php://input'), true);

// بررسی توکن ساده (برای امنیت)
// $providedToken = $_GET['token'] ?? $input['token'] ?? '';
// if (!$storyObj->verifyToken($providedToken)) {
//     http_response_code(401);
//     echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
//     exit;
// }

switch($method) {
    case 'GET':
        // اگر id داده شده، فقط همان استوری، در غیر اینصورت همه استوری‌ها با limit و sort
        $limit = $_GET['limit'] ?? 10;
        $sortLike = $_GET['sortLike'] ?? 'desc';
        $sortTime = $_GET['sortTime'] ?? 'desc';

        if ($id) {
            $story = $storyObj->getStories($limit, $sortLike, $sortTime);
            echo json_encode(['status' => 'success', 'data' => $story]);
        } else {
            $stories = $storyObj->getStories($limit, $sortLike, $sortTime);
            echo json_encode(['status' => 'success', 'count' => count($stories), 'data' => $stories]);
        }
        break;

    case 'POST':
        // اضافه کردن استوری جدید
        $user_id = $input['user_id'] ?? null;
        $content_type = $input['content_type'] ?? 'image';
        $content_url = $input['content_url'] ?? null;
        $caption = $input['caption'] ?? null;

        if (!$user_id || !$content_url) {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'user_id and content_url are required']);
            exit;
        }

        $newId = $storyObj->addStory($user_id, $content_type, $content_url, $caption);
        echo json_encode(['status' => 'success', 'story_id' => $newId]);
        break;

    case 'PUT':
        // بروزرسانی استوری (مثلاً تغییر caption یا status)
        if ($id) {
            $storyObj->updateStory($id, $input);
            echo json_encode(['status' => 'success', 'message' => 'updated']);
        } else {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'ID is required for update']);
        }
        break;

    case 'DELETE':
        if ($id) {
            $storyObj->deleteStory($id);
            echo json_encode(['status' => 'success', 'message' => 'deleted']);
        } else {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'ID is required for delete']);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
        break;
}