<?php
header('Content-Type: application/json');

require_once '../db/functions.php';
require_once '../db/sliders/slider.php';

$slider = new Slider($conn);

$method = $_SERVER['REQUEST_METHOD'];
$id = $_GET['id'] ?? null;
$input = json_decode(file_get_contents('php://input'), true);

switch($method) {
    case 'GET':
        echo json_encode($id ? $slider->get($id) : $slider->getAll());
        break;

    case 'POST':
        $newId = $slider->create($input);
        echo json_encode(['id' => $newId]);
        break;

    case 'PUT':
        if ($id) {
            $slider->update($id, $input);
            echo json_encode(['status' => 'updated']);
        }
        break;

    case 'DELETE':
        if ($id) {
            $slider->delete($id);
            echo json_encode(['status' => 'deleted']);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        break;
}