<?php
header('Content-Type: application/json');

require_once '../db/functions.php';
require_once '../db/settings/setting.php';

$setting = new Setting($conn);

$method = $_SERVER['REQUEST_METHOD'];
$id = $_GET['id'] ?? null;
$input = json_decode(file_get_contents('php://input'), true);

switch($method) {
    case 'GET':
        echo json_encode($id ? $setting->get($id) : $setting->getAll());
        break;

    case 'POST':
        $newId = $setting->create($input);
        echo json_encode(['id' => $newId]);
        break;

    case 'PUT':
        if ($id) {
            $setting->update($id, $input);
            echo json_encode(['status' => 'updated']);
        }
        break;

    case 'DELETE':
        if ($id) {
            $setting->delete($id);
            echo json_encode(['status' => 'deleted']);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        break;
}