<?php require_once 'controlls/functions.php' ?>
<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $setting_site_name ?></title>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'licorice': '#1C110A',
                        'vanilla': '#E4D6A7',
                        'hunyadi': '#E9B44C',
                        'seal-brown': '#672806',
                        'verdigris': '#50A2A7'
                    }
                }
            }
        }
    </script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        body {
            font-family: 'Inter', sans-serif;
        }
        
        .glass-effect {
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #50A2A7 0%, #E9B44C 50%, #672806 100%);
        }
        
        .input-focus:focus {
            box-shadow: 0 0 0 3px rgba(233, 180, 76, 0.3);
            border-color: #E9B44C;
        }
        
        .btn-hover:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(233, 180, 76, 0.4);
        }
        
        
    </style>
</head>