<?php 
include 'views/headin-dashboard.php';
?>
        <!-- Settings Content -->
        <main class="p-6">
            <!-- Header Section -->
            <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div>
                    <h1 class="text-3xl font-bold text-licorice mb-2">Settings ⚙️</h1>
                    <p class="text-gray-600">Manage system settings and configurations</p>
                </div>
                <button class="btn-primary px-6 py-3 rounded-xl text-white font-semibold flex items-center justify-center gap-2 shadow-lg hover-lift">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                    </svg>
                    Reset Settings
                </button>
            </div>

            <!-- Settings Categories -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- General Settings -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h3 class="text-lg font-bold text-licorice mb-4">General Settings</h3>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Site Name</span>
                            <span class="text-sm text-gray-500">AmeasyShop</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Site URL</span>
                            <span class="text-sm text-gray-500">https://ameasyshop.com</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Default Currency</span>
                            <span class="text-sm text-gray-500">USD</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Timezone</span>
                            <span class="text-sm text-gray-500">UTC-5</span>
                        </div>
                        <button class="w-full px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold hover:bg-verdigris/90 transition-colors">Edit Settings</button>
                    </div>
                </div>

                <!-- Email Settings -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h3 class="text-lg font-bold text-licorice mb-4">Email Settings</h3>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">SMTP Server</span>
                            <span class="text-sm text-gray-500">smtp.gmail.com</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">SMTP Port</span>
                            <span class="text-sm text-gray-500">587</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">From Email</span>
                            <span class="text-sm text-gray-500">noreply@ameasyshop.com</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Email Templates</span>
                            <button class="px-3 py-1 bg-verdigris text-white rounded text-xs font-semibold">Manage</button>
                        </div>
                        <button class="w-full px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold hover:bg-verdigris/90 transition-colors">Configure Email</button>
                    </div>
                </div>

                <!-- Payment Settings -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h3 class="text-lg font-bold text-licorice mb-4">Payment Settings</h3>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Stripe API Key</span>
                            <span class="text-sm text-gray-500">pk_live_***</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">PayPal Client ID</span>
                            <span class="text-sm text-gray-500">AeA1QIX***</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Payment Methods</span>
                            <span class="text-sm text-gray-500">Credit Card, PayPal</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Currency</span>
                            <span class="text-sm text-gray-500">USD</span>
                        </div>
                        <button class="w-full px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold hover:bg-verdigris/90 transition-colors">Configure Payments</button>
                    </div>
                </div>

                <!-- System Settings -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h3 class="text-lg font-bold text-licorice mb-4">System Settings</h3>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Maintenance Mode</span>
                            <button class="px-3 py-1 bg-red-100 text-red-700 rounded text-xs font-semibold">Disabled</button>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Debug Mode</span>
                            <button class="px-3 py-1 bg-green-100 text-green-700 rounded text-xs font-semibold">Enabled</button>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Cache Status</span>
                            <button class="px-3 py-1 bg-green-100 text-green-700 rounded text-xs font-semibold">Active</button>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Backup Status</span>
                            <span class="text-sm text-gray-500">Last: Jul 15, 2024</span>
                        </div>
                        <button class="w-full px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold hover:bg-verdigris/90 transition-colors">System Tools</button>
                    </div>
                </div>
            </div>
        </main>

<?php require_once 'views/fotter-dashboard.php'; ?>
