<?php 
include 'views/headin-dashboard.php';
?>
        <!-- Security Settings Content -->
        <main class="p-6">
            <!-- Header Section -->
            <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div>
                    <h1 class="text-3xl font-bold text-licorice mb-2">Security Settings 🔒</h1>
                    <p class="text-gray-600">Manage security settings and access controls</p>
                </div>
                <button class="btn-primary px-6 py-3 rounded-xl text-white font-semibold flex items-center justify-center gap-2 shadow-lg hover-lift">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                    </svg>
                    Security Scan
                </button>
            </div>

            <!-- Security Status -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-green-500 to-green-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-green-500 text-sm font-semibold">Secure</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">SSL Status</h3>
                    <p class="text-2xl font-bold text-licorice">Active</p>
                </div>

                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-verdigris to-verdigris/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                            </svg>
                        </div>
                        <span class="text-verdigris text-sm font-semibold">Protected</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Login Attempts</h3>
                    <p class="text-2xl font-bold text-licorice">23</p>
                </div>

                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-hunyadi to-hunyadi/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-orange-500 text-sm font-semibold">Alerts</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Security Alerts</h3>
                    <p class="text-2xl font-bold text-licorice">2</p>
                </div>

                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                            </svg>
                        </div>
                        <span class="text-purple-500 text-sm font-semibold">Score</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Security Score</h3>
                    <p class="text-2xl font-bold text-licorice">95%</p>
                </div>
            </div>

            <!-- Security Settings -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Access Control -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h3 class="text-lg font-bold text-licorice mb-4">Access Control</h3>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Two-Factor Authentication</span>
                            <button class="px-4 py-2 bg-green-100 text-green-700 rounded-lg text-sm font-semibold">Enabled</button>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Password Policy</span>
                            <button class="px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold">Configure</button>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Session Timeout</span>
                            <span class="text-sm text-gray-500">30 minutes</span>
                        </div>
                    </div>
                </div>

                <!-- Security Monitoring -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h3 class="text-lg font-bold text-licorice mb-4">Security Monitoring</h3>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Failed Login Alerts</span>
                            <button class="px-4 py-2 bg-green-100 text-green-700 rounded-lg text-sm font-semibold">Active</button>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">IP Blocking</span>
                            <button class="px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold">Configure</button>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Security Logs</span>
                            <button class="px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold">View</button>
                        </div>
                    </div>
                </div>
            </div>
        </main>

<?php require_once 'views/fotter-dashboard.php'; ?>
