<?php 
include 'views/headin-dashboard.php';
?>
        <!-- Reports Content -->
        <main class="p-6">
            <!-- Header Section -->
            <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div>
                    <h1 class="text-3xl font-bold text-licorice mb-2">Reports 📊</h1>
                    <p class="text-gray-600">Generate and view business reports</p>
                </div>
                <button class="btn-primary px-6 py-3 rounded-xl text-white font-semibold flex items-center justify-center gap-2 shadow-lg hover-lift">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                    </svg>
                    Generate Report
                </button>
            </div>

            <!-- Report Stats -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-verdigris to-verdigris/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                        </div>
                        <span class="text-verdigris text-sm font-semibold">Total</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Total Reports</h3>
                    <p class="text-2xl font-bold text-licorice">24</p>
                </div>

                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-green-500 to-green-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-green-500 text-sm font-semibold">Generated</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">This Month</h3>
                    <p class="text-2xl font-bold text-licorice">8</p>
                </div>

                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-hunyadi to-hunyadi/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-orange-500 text-sm font-semibold">Scheduled</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Scheduled Reports</h3>
                    <p class="text-2xl font-bold text-licorice">5</p>
                </div>

                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                            </svg>
                        </div>
                        <span class="text-purple-500 text-sm font-semibold">Exports</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Exported Today</h3>
                    <p class="text-2xl font-bold text-licorice">3</p>
                </div>
            </div>

            <!-- Report Types -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Sales Reports -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h3 class="text-lg font-bold text-licorice mb-4">Sales Reports</h3>
                    <div class="space-y-3">
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div>
                                <div class="font-semibold text-sm">Daily Sales Report</div>
                                <div class="text-xs text-gray-500">Revenue and order summary</div>
                            </div>
                            <button class="px-3 py-1 bg-verdigris text-white rounded text-xs font-semibold">Generate</button>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div>
                                <div class="font-semibold text-sm">Monthly Sales Report</div>
                                <div class="text-xs text-gray-500">Comprehensive monthly analysis</div>
                            </div>
                            <button class="px-3 py-1 bg-verdigris text-white rounded text-xs font-semibold">Generate</button>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div>
                                <div class="font-semibold text-sm">Product Performance</div>
                                <div class="text-xs text-gray-500">Top selling products</div>
                            </div>
                            <button class="px-3 py-1 bg-verdigris text-white rounded text-xs font-semibold">Generate</button>
                        </div>
                    </div>
                </div>

                <!-- Customer Reports -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h3 class="text-lg font-bold text-licorice mb-4">Customer Reports</h3>
                    <div class="space-y-3">
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div>
                                <div class="font-semibold text-sm">Customer Analytics</div>
                                <div class="text-xs text-gray-500">Customer behavior and trends</div>
                            </div>
                            <button class="px-3 py-1 bg-verdigris text-white rounded text-xs font-semibold">Generate</button>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div>
                                <div class="font-semibold text-sm">Customer Lifetime Value</div>
                                <div class="text-xs text-gray-500">CLV analysis and insights</div>
                            </div>
                            <button class="px-3 py-1 bg-verdigris text-white rounded text-xs font-semibold">Generate</button>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div>
                                <div class="font-semibold text-sm">Retention Report</div>
                                <div class="text-xs text-gray-500">Customer retention metrics</div>
                            </div>
                            <button class="px-3 py-1 bg-verdigris text-white rounded text-xs font-semibold">Generate</button>
                        </div>
                    </div>
                </div>
            </div>
        </main>

<?php require_once 'views/fotter-dashboard.php'; ?>
