<?php 
include 'views/headin-dashboard.php';
?>
        <!-- Promotions Management Content -->
        <main class="p-6">
            <!-- Header Section -->
            <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div>
                    <h1 class="text-3xl font-bold text-licorice mb-2">Promotions Management 🎯</h1>
                    <p class="text-gray-600">Manage discounts, coupons, and promotional campaigns</p>
                </div>
                <button class="btn-primary px-6 py-3 rounded-xl text-white font-semibold flex items-center justify-center gap-2 shadow-lg hover-lift">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                    </svg>
                    Create Promotion
                </button>
            </div>

            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
                <!-- Active Promotions -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-verdigris to-verdigris/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-verdigris text-sm font-semibold">Active</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Active Promotions</h3>
                    <p class="text-2xl font-bold text-licorice">12</p>
                </div>

                <!-- Total Coupons -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-green-500 to-green-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                            </svg>
                        </div>
                        <span class="text-green-500 text-sm font-semibold">Coupons</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Total Coupons</h3>
                    <p class="text-2xl font-bold text-licorice">45</p>
                </div>

                <!-- Total Discounts -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-hunyadi to-hunyadi/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-orange-500 text-sm font-semibold">Savings</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Total Discounts Given</h3>
                    <p class="text-2xl font-bold text-licorice">$12,450</p>
                </div>

                <!-- Conversion Rate -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                            </svg>
                        </div>
                        <span class="text-purple-500 text-sm font-semibold">Rate</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Conversion Rate</h3>
                    <p class="text-2xl font-bold text-licorice">23.5%</p>
                </div>
            </div>

            <!-- Active Promotions -->
            <div class="bg-white rounded-xl shadow-md overflow-hidden mb-6">
                <div class="p-6 border-b border-gray-200">
                    <h2 class="text-xl font-bold text-licorice">Active Promotions</h2>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Promotion</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Type</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Discount</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Usage</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Valid Until</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="font-semibold text-licorice">Summer Sale 2024</div>
                                    <div class="text-sm text-gray-500">SUMMER2024</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">Percentage</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">25% OFF</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">234/500</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">Aug 31, 2024</td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-3 py-1 bg-green-100 text-green-700 rounded-full text-xs font-semibold">Active</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <div class="flex items-center gap-2">
                                        <button class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors" title="Edit">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                            </svg>
                                        </button>
                                        <button class="p-2 text-red-600 hover:bg-red-50 rounded-lg transition-colors" title="Deactivate">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728L5.636 5.636m12.728 12.728L18.364 5.636M5.636 18.364l12.728-12.728"/>
                                            </svg>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="font-semibold text-licorice">Free Shipping Weekend</div>
                                    <div class="text-sm text-gray-500">FREESHIP</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">Fixed Amount</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">$0.00 Shipping</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">89/200</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">Jul 15, 2024</td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-3 py-1 bg-green-100 text-green-700 rounded-full text-xs font-semibold">Active</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <div class="flex items-center gap-2">
                                        <button class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors" title="Edit">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                            </svg>
                                        </button>
                                        <button class="p-2 text-red-600 hover:bg-red-50 rounded-lg transition-colors" title="Deactivate">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728L5.636 5.636m12.728 12.728L18.364 5.636M5.636 18.364l12.728-12.728"/>
                                            </svg>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Coupon Codes -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
                <!-- Recent Coupons -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-bold text-licorice">Recent Coupons</h3>
                        <button class="text-verdigris hover:text-seal-brown transition-colors text-sm font-semibold">View All</button>
                    </div>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 bg-gradient-to-br from-verdigris to-hunyadi rounded-lg flex items-center justify-center text-white font-bold text-sm">
                                    %
                                </div>
                                <div>
                                    <div class="font-semibold text-sm">WELCOME10</div>
                                    <div class="text-xs text-gray-500">10% off first order</div>
                                </div>
                            </div>
                            <span class="px-2 py-1 bg-green-100 text-green-700 rounded text-xs font-semibold">Active</span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 bg-gradient-to-br from-hunyadi to-seal-brown rounded-lg flex items-center justify-center text-white font-bold text-sm">
                                    $
                                </div>
                                <div>
                                    <div class="font-semibold text-sm">SAVE20</div>
                                    <div class="text-xs text-gray-500">$20 off $100+</div>
                                </div>
                            </div>
                            <span class="px-2 py-1 bg-yellow-100 text-yellow-700 rounded text-xs font-semibold">Expiring</span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 bg-gradient-to-br from-seal-brown to-licorice rounded-lg flex items-center justify-center text-white font-bold text-sm">
                                    🎁
                                </div>
                                <div>
                                    <div class="font-semibold text-sm">GIFT50</div>
                                    <div class="text-xs text-gray-500">$50 gift card</div>
                                </div>
                            </div>
                            <span class="px-2 py-1 bg-red-100 text-red-700 rounded text-xs font-semibold">Expired</span>
                        </div>
                    </div>
                </div>

                <!-- Promotion Performance -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-bold text-licorice">Top Performing Promotions</h3>
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                        </svg>
                    </div>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 bg-gradient-to-br from-verdigris to-hunyadi rounded-lg flex items-center justify-center text-white font-bold text-xs">1</div>
                                <div>
                                    <div class="font-semibold text-sm">Black Friday Sale</div>
                                    <div class="text-xs text-gray-500">40% off everything</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="font-bold text-sm">1,234 uses</div>
                                <div class="text-xs text-gray-500">$12,340 saved</div>
                            </div>
                        </div>
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 bg-gradient-to-br from-hunyadi to-seal-brown rounded-lg flex items-center justify-center text-white font-bold text-xs">2</div>
                                <div>
                                    <div class="font-semibold text-sm">Student Discount</div>
                                    <div class="text-xs text-gray-500">15% off with .edu email</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="font-bold text-sm">567 uses</div>
                                <div class="text-xs text-gray-500">$3,405 saved</div>
                            </div>
                        </div>
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 bg-gradient-to-br from-seal-brown to-licorice rounded-lg flex items-center justify-center text-white font-bold text-xs">3</div>
                                <div>
                                    <div class="font-semibold text-sm">Loyalty Rewards</div>
                                    <div class="text-xs text-gray-500">$10 off $50+ orders</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="font-bold text-sm">234 uses</div>
                                <div class="text-xs text-gray-500">$2,340 saved</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Promotion Types -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Percentage Discount -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-bold text-licorice">Percentage Discount</h3>
                        <span class="px-3 py-1 bg-blue-100 text-blue-700 rounded-full text-xs font-semibold">Popular</span>
                    </div>
                    <p class="text-gray-600 text-sm mb-4">Offer a percentage discount on products or orders</p>
                    <div class="space-y-2 mb-4">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Active campaigns:</span>
                            <span class="font-semibold">5</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Total usage:</span>
                            <span class="font-semibold">1,234</span>
                        </div>
                    </div>
                    <button class="w-full px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold hover:bg-verdigris/90 transition-colors">Create Campaign</button>
                </div>

                <!-- Fixed Amount -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-bold text-licorice">Fixed Amount</h3>
                        <span class="px-3 py-1 bg-green-100 text-green-700 rounded-full text-xs font-semibold">Effective</span>
                    </div>
                    <p class="text-gray-600 text-sm mb-4">Offer a fixed dollar amount discount</p>
                    <div class="space-y-2 mb-4">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Active campaigns:</span>
                            <span class="font-semibold">3</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Total usage:</span>
                            <span class="font-semibold">567</span>
                        </div>
                    </div>
                    <button class="w-full px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold hover:bg-verdigris/90 transition-colors">Create Campaign</button>
                </div>

                <!-- Free Shipping -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-bold text-licorice">Free Shipping</h3>
                        <span class="px-3 py-1 bg-purple-100 text-purple-700 rounded-full text-xs font-semibold">Boost Sales</span>
                    </div>
                    <p class="text-gray-600 text-sm mb-4">Offer free shipping on qualifying orders</p>
                    <div class="space-y-2 mb-4">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Active campaigns:</span>
                            <span class="font-semibold">2</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Total usage:</span>
                            <span class="font-semibold">89</span>
                        </div>
                    </div>
                    <button class="w-full px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold hover:bg-verdigris/90 transition-colors">Create Campaign</button>
                </div>
            </div>
        </main>

<?php require_once 'views/fotter-dashboard.php'; ?>