<?php 
include 'views/headin-dashboard.php';
?>
        <!-- Products Page Content -->
        <main class="p-6">
            <!-- Header Section -->
            <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div>
                    <h1 class="text-3xl font-bold text-licorice mb-2">Products Management 📦</h1>
                    <p class="text-gray-600">Manage your product inventory</p>
                </div>
                <button id="addProductBtn" class="btn-primary px-6 py-3 rounded-xl text-white font-semibold flex items-center justify-center gap-2 shadow-lg hover-lift">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                    </svg>
                    Add New Product
                </button>
            </div>

            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
                <!-- Total Products -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-verdigris to-verdigris/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                            </svg>
                        </div>
                        <span class="text-verdigris text-sm font-semibold">Total</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Total Products</h3>
                    <p id="totalProducts" class="text-2xl font-bold text-licorice">
                        <span class="inline-block animate-pulse">...</span>
                    </p>
                </div>

                <!-- Active Products -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-green-500 to-green-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-green-500 text-sm font-semibold">Active</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Active Products</h3>
                    <p id="activeProducts" class="text-2xl font-bold text-licorice">
                        <span class="inline-block animate-pulse">...</span>
                    </p>
                </div>

                <!-- Low Stock -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-hunyadi to-hunyadi/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                            </svg>
                        </div>
                        <span class="text-orange-500 text-sm font-semibold">Alert</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Low Stock</h3>
                    <p id="lowStockProducts" class="text-2xl font-bold text-licorice">
                        <span class="inline-block animate-pulse">...</span>
                    </p>
                </div>

                <!-- Out of Stock -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-red-500 to-red-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </div>
                        <span class="text-red-500 text-sm font-semibold">Unavailable</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Out of Stock</h3>
                    <p id="outOfStockProducts" class="text-2xl font-bold text-licorice">
                        <span class="inline-block animate-pulse">...</span>
                    </p>
                </div>
            </div>

            <!-- Filters & Search -->
            <div class="bg-white rounded-xl shadow-md p-6 mb-6">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <!-- Search -->
                    <div class="md:col-span-2">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">Search Products</label>
                        <div class="relative">
                            <input 
                                type="text" 
                                placeholder="Search by name, SKU, or category..." 
                                class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                            <svg class="absolute left-3 top-2.5 w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                            </svg>
                        </div>
                    </div>

                    <!-- Category Filter -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">Category</label>
                        <select class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all">
                            <option value="">All Categories</option>
                            <option value="electronics">Electronics</option>
                            <option value="clothing">Clothing</option>
                            <option value="food">Food & Beverage</option>
                            <option value="other">Other</option>
                        </select>
                    </div>

                    <!-- Status Filter -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">Status</label>
                        <select class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all">
                            <option value="">All Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                            <option value="low-stock">Low Stock</option>
                            <option value="out-of-stock">Out of Stock</option>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Products Table -->
            <div class="bg-white rounded-xl shadow-md overflow-hidden">
                <div class="p-6 border-b border-gray-200">
                    <h2 class="text-xl font-bold text-licorice">Product List</h2>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">
                                    <input type="checkbox" class="rounded border-gray-300 text-verdigris focus:ring-verdigris">
                                </th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Image</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Product Name</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">SKU</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Category</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Price</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Stock</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200" id="productsTableBody">
                            <!-- Empty State -->
                            <tr>
                                <td colspan="9" class="px-6 py-16 text-center">
                                    <div class="flex flex-col items-center justify-center">
                                        <svg class="w-24 h-24 text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                                        </svg>
                                        <h3 class="text-xl font-semibold text-gray-600 mb-2">No Products Found</h3>
                                        <p class="text-gray-500 mb-6">Get started by adding your first product</p>
                                        <a href="add-product" class="btn-primary px-6 py-3 rounded-xl text-white font-semibold inline-flex items-center gap-2 shadow-lg hover-lift">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                                            </svg>
                                            Add First Product
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            
                            <!-- Example Row (Hidden by default - will be populated dynamically) -->
                            <!-- 
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <input type="checkbox" class="rounded border-gray-300 text-verdigris focus:ring-verdigris">
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <img src="https://via.placeholder.com/50" alt="Product" class="w-12 h-12 object-cover rounded-lg">
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="font-semibold text-licorice">Product Name</div>
                                    <div class="text-sm text-gray-500">Product description</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">SKU-001</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">Electronics</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-licorice">$99.99</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">50</td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-3 py-1 bg-green-100 text-green-700 rounded-full text-xs font-semibold">Active</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <div class="flex items-center gap-2">
                                        <button class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors" title="Edit">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                            </svg>
                                        </button>
                                        <button class="p-2 text-red-600 hover:bg-red-50 rounded-lg transition-colors" title="Delete">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                            </svg>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            -->
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex flex-col sm:flex-row items-center justify-between gap-4">
                    <div class="text-sm text-gray-600">
                        Showing <span class="font-semibold">0</span> to <span class="font-semibold">0</span> of <span class="font-semibold">0</span> results
                    </div>
                    <div class="flex items-center gap-2">
                        <button class="px-4 py-2 border border-gray-300 rounded-lg text-sm font-semibold text-gray-600 hover:bg-gray-100 transition-colors disabled:opacity-50 disabled:cursor-not-allowed" disabled>
                            Previous
                        </button>
                        <button class="px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold">1</button>
                        <button class="px-4 py-2 border border-gray-300 rounded-lg text-sm font-semibold text-gray-600 hover:bg-gray-100 transition-colors disabled:opacity-50 disabled:cursor-not-allowed" disabled>
                            Next
                        </button>
                    </div>
                </div>
            </div>
        </main>

    <script>
        // Mobile offcanvas menu
        const menuToggle = document.getElementById('menuToggle');
        const closeSidebar = document.getElementById('closeSidebar');
        const sidebar = document.getElementById('sidebar');
        const sidebarBackdrop = document.getElementById('sidebarBackdrop');
        const mainContent = document.getElementById('mainContent');

        // Function to open sidebar
        function openSidebar() {
            sidebar.classList.add('active');
            sidebarBackdrop.classList.add('active');
            document.body.style.overflow = 'hidden';
        }

        // Function to close sidebar
        function closeSidebarFunc() {
            sidebar.classList.remove('active');
            sidebarBackdrop.classList.remove('active');
            document.body.style.overflow = '';
        }

        // Toggle sidebar on menu button click
        menuToggle.addEventListener('click', function() {
            if (sidebar.classList.contains('active')) {
                closeSidebarFunc();
            } else {
                openSidebar();
            }
        });

        // Close sidebar on close button click
        closeSidebar.addEventListener('click', closeSidebarFunc);

        // Close sidebar when clicking on backdrop
        sidebarBackdrop.addEventListener('click', closeSidebarFunc);

        // Close sidebar on window resize if screen is large
        window.addEventListener('resize', function() {
            if (window.innerWidth >= 1024) {
                closeSidebarFunc();
            }
        });

        // Close sidebar when pressing Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && sidebar.classList.contains('active')) {
                closeSidebarFunc();
            }
        });

        // Add Product Button Handler
        document.getElementById('addProductBtn').addEventListener('click', function() {
            window.location.href = 'add-product';
        });

        // Load Products from API
        function loadProducts() {
            const tableBody = document.getElementById('productsTableBody');
            tableBody.innerHTML = '<tr><td colspan="9" class="px-6 py-8 text-center text-gray-500">Loading products...</td></tr>';
            
            fetch('api/products.php', {
                method: 'GET'
            })
            .then(response => response.json())
            .then(data => {
                console.log('API Response:', data);
                if (data.success === true && data.data.products.length > 0) {
                    displayProducts(data.data.products);
                    updateStats(data.data.products);
                } else {
                    // Show empty state
                    tableBody.innerHTML = `
                        <tr>
                            <td colspan="9" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center justify-center">
                                    <svg class="w-24 h-24 text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                                    </svg>
                                    <h3 class="text-xl font-semibold text-gray-600 mb-2">No Products Found</h3>
                                    <p class="text-gray-500 mb-6">Get started by adding your first product</p>
                                    <a href="add-product" class="btn-primary px-6 py-3 rounded-xl text-white font-semibold inline-flex items-center gap-2 shadow-lg hover-lift">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                                        </svg>
                                        Add First Product
                                    </a>
                                </div>
                            </td>
                        </tr>
                    `;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                tableBody.innerHTML = '<tr><td colspan="9" class="px-6 py-8 text-center text-red-500">Error loading products</td></tr>';
            });
        }
        
        // Display products in table
        function displayProducts(products) {
            const tableBody = document.getElementById('productsTableBody');
            let html = '';
            
            products.forEach(product => {
                const statusBadge = getStatusBadge(product.status);
                const stockBadge = getStockBadge(product.stock_quantity, product.low_stock_alert);
                const image = product.primary_image || 'https://via.placeholder.com/50';
                
                html += `
                    <tr class="hover:bg-gray-50 transition-colors">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <input type="checkbox" class="rounded border-gray-300 text-verdigris focus:ring-verdigris" value="${product.id}">
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <img src="${image}" alt="${product.product_name}" class="w-12 h-12 object-cover rounded-lg border border-gray-200">
                        </td>
                        <td class="px-6 py-4">
                            <div class="font-semibold text-licorice">${product.product_name}</div>
                            <div class="text-sm text-gray-500">${product.brand || 'No brand'}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">${product.sku}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700 capitalize">${product.category}</td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            ${product.sale_price ? `
                                <div class="text-sm font-semibold text-green-600">$${product.sale_price}</div>
                                <div class="text-xs text-gray-400 line-through">$${product.regular_price}</div>
                            ` : `
                                <div class="text-sm font-semibold text-licorice">$${product.regular_price}</div>
                            `}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            ${stockBadge}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            ${statusBadge}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex items-center gap-2">
                                <button onclick="editProduct(${product.id})" class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors" title="Edit">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                    </svg>
                                </button>
                                <button onclick="deleteProduct(${product.id}, '${product.product_name}')" class="p-2 text-red-600 hover:bg-red-50 rounded-lg transition-colors" title="Delete">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                    </svg>
                                </button>
                            </div>
                        </td>
                    </tr>
                `;
            });
            
            tableBody.innerHTML = html;
        }
        
        // Get status badge HTML
        function getStatusBadge(status) {
            const badges = {
                'active': '<span class="px-3 py-1 bg-green-100 text-green-700 rounded-full text-xs font-semibold">Active</span>',
                'inactive': '<span class="px-3 py-1 bg-gray-100 text-gray-700 rounded-full text-xs font-semibold">Inactive</span>',
                'draft': '<span class="px-3 py-1 bg-yellow-100 text-yellow-700 rounded-full text-xs font-semibold">Draft</span>'
            };
            return badges[status] || badges['draft'];
        }
        
        // Get stock badge HTML
        function getStockBadge(quantity, lowAlert) {
            const qty = parseInt(quantity);
            const alert = parseInt(lowAlert) || 10;
            
            if (qty === 0) {
                return '<span class="text-sm text-red-600 font-semibold">Out of Stock</span>';
            } else if (qty <= alert) {
                return `<span class="text-sm text-orange-600 font-semibold">${qty} <span class="text-xs">(Low)</span></span>`;
            } else {
                return `<span class="text-sm text-gray-700">${qty}</span>`;
            }
        }
        
        // Update stats cards with animation
        function updateStats(products) {
            const total = products.length;
            const active = products.filter(p => p.status === 'active').length;
            const lowStock = products.filter(p => {
                const qty = parseInt(p.stock_quantity);
                const alert = parseInt(p.low_stock_alert) || 10;
                return qty <= alert && qty > 0;
            }).length;
            const outOfStock = products.filter(p => parseInt(p.stock_quantity) === 0).length;
            
            // Animate counter update
            animateCounter('totalProducts', total);
            animateCounter('activeProducts', active);
            animateCounter('lowStockProducts', lowStock);
            animateCounter('outOfStockProducts', outOfStock);
        }
        
        // Animate counter from current value to target value
        function animateCounter(elementId, targetValue) {
            const element = document.getElementById(elementId);
            const currentValue = parseInt(element.textContent) || 0;
            const duration = 1000; // 1 second
            const steps = 30;
            const increment = (targetValue - currentValue) / steps;
            const stepDuration = duration / steps;
            
            let current = currentValue;
            let step = 0;
            
            const timer = setInterval(() => {
                step++;
                current += increment;
                
                if (step >= steps) {
                    element.textContent = targetValue;
                    clearInterval(timer);
                } else {
                    element.textContent = Math.round(current);
                }
            }, stepDuration);
        }
        
        // Edit product
        function editProduct(id) {
            window.location.href = `edit-product?id=${id}`;
        }
        
        // Delete product
        function deleteProduct(id, name) {
            if (confirm(`Are you sure you want to delete "${name}"?`)) {
                fetch(`api/products.php?id=${id}`, {
                    method: 'DELETE'
                })
                .then(response => response.json())
                .then(data => {
                    console.log('Delete Response:', data);
                    if (data.success === true) {
                        showNotification('success', 'Product deleted successfully');
                        loadProducts(); // Reload products
                    } else {
                        showNotification('error', data.message || 'Failed to delete product');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    showNotification('error', 'Network error. Please try again.');
                });
            }
        }
        
        // Show notification
        function showNotification(type, message) {
            const notification = document.createElement('div');
            notification.className = `notification ${type} show`;
            notification.innerHTML = `
                <div class="flex items-center">
                    <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        ${type === 'success' 
                            ? '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>'
                            : '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>'
                        }
                    </svg>
                    <span>${message}</span>
                </div>
            `;
            document.body.appendChild(notification);
            
            setTimeout(() => {
                notification.remove();
            }, 5000);
        }
        
        // Load products on page load
        loadProducts();

        // Add animation to cards on scroll
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver(function(entries) {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Initially hide elements for animation
        document.querySelectorAll('.grid > div, .bg-white').forEach(el => {
            el.style.opacity = '0';
            el.style.transform = 'translateY(20px)';
            el.style.transition = 'all 0.5s ease-out';
            observer.observe(el);
        });
    </script>
<?php require_once 'views/fotter-dashboard.php'; ?>
