<?php 
include 'views/headin-dashboard.php';

// Sample orders data - in a real application, this would come from database
$orders = [
    [
        'id' => 'ORD-001',
        'customer_name' => 'John Smith',
        'customer_email' => 'john@example.com',
        'order_date' => '2024-01-15',
        'status' => 'pending',
        'total' => 299.99,
        'items' => 3,
        'payment_method' => 'Credit Card',
        'shipping_address' => '123 Main St, New York, NY 10001'
    ],
    [
        'id' => 'ORD-002',
        'customer_name' => 'Sarah Johnson',
        'customer_email' => 'sarah@example.com',
        'order_date' => '2024-01-14',
        'status' => 'completed',
        'total' => 149.50,
        'items' => 2,
        'payment_method' => 'PayPal',
        'shipping_address' => '456 Oak Ave, Los Angeles, CA 90210'
    ],
    [
        'id' => 'ORD-003',
        'customer_name' => 'Mike Wilson',
        'customer_email' => 'mike@example.com',
        'order_date' => '2024-01-13',
        'status' => 'shipped',
        'total' => 89.99,
        'items' => 1,
        'payment_method' => 'Stripe',
        'shipping_address' => '789 Pine Rd, Chicago, IL 60601'
    ],
    [
        'id' => 'ORD-004',
        'customer_name' => 'Emily Davis',
        'customer_email' => 'emily@example.com',
        'order_date' => '2024-01-12',
        'status' => 'cancelled',
        'total' => 199.99,
        'items' => 4,
        'payment_method' => 'Credit Card',
        'shipping_address' => '321 Elm St, Miami, FL 33101'
    ],
    [
        'id' => 'ORD-005',
        'customer_name' => 'David Brown',
        'customer_email' => 'david@example.com',
        'order_date' => '2024-01-11',
        'status' => 'processing',
        'total' => 399.99,
        'items' => 2,
        'payment_method' => 'Bank Transfer',
        'shipping_address' => '654 Maple Dr, Seattle, WA 98101'
    ],
    [
        'id' => 'ORD-006',
        'customer_name' => 'Lisa Anderson',
        'customer_email' => 'lisa@example.com',
        'order_date' => '2024-01-10',
        'status' => 'completed',
        'total' => 79.99,
        'items' => 1,
        'payment_method' => 'PayPal',
        'shipping_address' => '987 Cedar Ln, Boston, MA 02101'
    ],
    [
        'id' => 'ORD-007',
        'customer_name' => 'Robert Taylor',
        'customer_email' => 'robert@example.com',
        'order_date' => '2024-01-09',
        'status' => 'shipped',
        'total' => 249.99,
        'items' => 3,
        'payment_method' => 'Credit Card',
        'shipping_address' => '147 Birch St, Denver, CO 80201'
    ],
    [
        'id' => 'ORD-008',
        'customer_name' => 'Jennifer Martinez',
        'customer_email' => 'jennifer@example.com',
        'order_date' => '2024-01-08',
        'status' => 'pending',
        'total' => 159.99,
        'items' => 2,
        'payment_method' => 'Stripe',
        'shipping_address' => '258 Spruce Ave, Phoenix, AZ 85001'
    ]
];

// Calculate statistics
$total_orders = count($orders);
$pending_orders = count(array_filter($orders, function($order) { return $order['status'] === 'pending'; }));
$completed_orders = count(array_filter($orders, function($order) { return $order['status'] === 'completed'; }));
$total_revenue = array_sum(array_column($orders, 'total'));

// Status colors mapping
$status_colors = [
    'pending' => 'bg-yellow-100 text-yellow-800',
    'processing' => 'bg-blue-100 text-blue-800',
    'shipped' => 'bg-purple-100 text-purple-800',
    'completed' => 'bg-green-100 text-green-800',
    'cancelled' => 'bg-red-100 text-red-800'
];

$status_labels = [
    'pending' => 'Pending',
    'processing' => 'Processing',
    'shipped' => 'Shipped',
    'completed' => 'Completed',
    'cancelled' => 'Cancelled'
];
?>

        <!-- Orders Content -->
        <main class="p-6">
            <!-- Header Section -->
            <div class="mb-6">
                <h1 class="text-3xl font-bold text-licorice mb-2">Orders Management 📦</h1>
                <p class="text-gray-600">Manage and track all customer orders</p>
            </div>

            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
                <!-- Total Orders -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-verdigris to-verdigris/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                            </svg>
                        </div>
                        <span class="text-blue-500 text-sm font-semibold">Total</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Total Orders</h3>
                    <p class="text-2xl font-bold text-licorice"><?php echo number_format($total_orders); ?></p>
                </div>

                <!-- Pending Orders -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-hunyadi to-hunyadi/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-orange-500 text-sm font-semibold">Pending</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Pending Orders</h3>
                    <p class="text-2xl font-bold text-licorice"><?php echo number_format($pending_orders); ?></p>
                </div>

                <!-- Completed Orders -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-green-500 to-green-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-green-500 text-sm font-semibold">Completed</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Completed Orders</h3>
                    <p class="text-2xl font-bold text-licorice"><?php echo number_format($completed_orders); ?></p>
                </div>

                <!-- Total Revenue -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-seal-brown to-seal-brown/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-green-500 text-sm font-semibold">Revenue</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Total Revenue</h3>
                    <p class="text-2xl font-bold text-licorice">$<?php echo number_format($total_revenue, 2); ?></p>
                </div>
            </div>

            <!-- Filters and Search -->
            <div class="bg-white rounded-xl shadow-md p-6 mb-6">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
                    <div class="flex flex-col sm:flex-row gap-4 flex-1">
                        <!-- Search -->
                        <div class="relative flex-1 max-w-md">
                            <input 
                                type="text" 
                                id="searchOrders"
                                placeholder="Search orders..." 
                                class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                            <svg class="absolute left-3 top-2.5 w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                            </svg>
                        </div>

                        <!-- Status Filter -->
                        <select id="statusFilter" class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all">
                            <option value="">All Status</option>
                            <option value="pending">Pending</option>
                            <option value="processing">Processing</option>
                            <option value="shipped">Shipped</option>
                            <option value="completed">Completed</option>
                            <option value="cancelled">Cancelled</option>
                        </select>

                        <!-- Date Filter -->
                        <input 
                            type="date" 
                            id="dateFilter"
                            class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                        >
                    </div>

                    <!-- Action Buttons -->
                    <div class="flex gap-2">
                        <button class="px-4 py-2 bg-verdigris text-white rounded-lg hover:bg-verdigris/90 transition-colors">
                            <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                            Export
                        </button>
                        <button class="px-4 py-2 bg-hunyadi text-white rounded-lg hover:bg-hunyadi/90 transition-colors">
                            <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"/>
                            </svg>
                            Refresh
                        </button>
                    </div>
                </div>
            </div>

            <!-- Orders Table -->
            <div class="bg-white rounded-xl shadow-md overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h2 class="text-xl font-bold text-licorice">Orders List</h2>
                    <p class="text-gray-600 text-sm">Manage all customer orders</p>
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Order ID</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Items</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Payment</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php foreach ($orders as $order): ?>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-licorice"><?php echo $order['id']; ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="flex-shrink-0 h-10 w-10">
                                            <div class="h-10 w-10 rounded-full bg-gradient-to-br from-verdigris to-hunyadi flex items-center justify-center text-white font-semibold">
                                                <?php echo strtoupper(substr($order['customer_name'], 0, 2)); ?>
                                            </div>
                                        </div>
                                        <div class="ml-4">
                                            <div class="text-sm font-medium text-licorice"><?php echo $order['customer_name']; ?></div>
                                            <div class="text-sm text-gray-500"><?php echo $order['customer_email']; ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900"><?php echo date('M j, Y', strtotime($order['order_date'])); ?></div>
                                    <div class="text-sm text-gray-500"><?php echo date('g:i A', strtotime($order['order_date'])); ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-3 py-1 <?php echo $status_colors[$order['status']]; ?> rounded-full text-xs font-semibold">
                                        <?php echo $status_labels[$order['status']]; ?>
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php echo $order['items']; ?> item<?php echo $order['items'] > 1 ? 's' : ''; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-licorice">
                                    $<?php echo number_format($order['total'], 2); ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php echo $order['payment_method']; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex space-x-2">
                                        <button class="text-verdigris hover:text-verdigris/80 transition-colors" title="View Details">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                            </svg>
                                        </button>
                                        <button class="text-hunyadi hover:text-hunyadi/80 transition-colors" title="Edit Order">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                            </svg>
                                        </button>
                                        <button class="text-green-600 hover:text-green-700 transition-colors" title="Update Status">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                            </svg>
                                        </button>
                                        <button class="text-red-600 hover:text-red-700 transition-colors" title="Cancel Order">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                            </svg>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="px-6 py-4 border-t border-gray-200">
                    <div class="flex items-center justify-between">
                        <div class="text-sm text-gray-700">
                            Showing <span class="font-medium">1</span> to <span class="font-medium">8</span> of <span class="font-medium">8</span> results
                        </div>
                        <div class="flex space-x-2">
                            <button class="px-3 py-2 text-sm font-medium text-gray-500 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 disabled:opacity-50 disabled:cursor-not-allowed" disabled>
                                Previous
                            </button>
                            <button class="px-3 py-2 text-sm font-medium text-white bg-verdigris border border-verdigris rounded-lg hover:bg-verdigris/90">
                                1
                            </button>
                            <button class="px-3 py-2 text-sm font-medium text-gray-500 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 disabled:opacity-50 disabled:cursor-not-allowed" disabled>
                                Next
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </main>

    <script>
        // Mobile offcanvas menu
        const menuToggle = document.getElementById('menuToggle');
        const closeSidebar = document.getElementById('closeSidebar');
        const sidebar = document.getElementById('sidebar');
        const sidebarBackdrop = document.getElementById('sidebarBackdrop');
        const mainContent = document.getElementById('mainContent');

        // Function to open sidebar
        function openSidebar() {
            sidebar.classList.add('active');
            sidebarBackdrop.classList.add('active');
            document.body.style.overflow = 'hidden';
        }

        // Function to close sidebar
        function closeSidebarFunc() {
            sidebar.classList.remove('active');
            sidebarBackdrop.classList.remove('active');
            document.body.style.overflow = '';
        }

        // Toggle sidebar on menu button click
        menuToggle.addEventListener('click', function() {
            if (sidebar.classList.contains('active')) {
                closeSidebarFunc();
            } else {
                openSidebar();
            }
        });

        // Close sidebar on close button click
        closeSidebar.addEventListener('click', closeSidebarFunc);

        // Close sidebar when clicking on backdrop
        sidebarBackdrop.addEventListener('click', closeSidebarFunc);

        // Close sidebar on window resize if screen is large
        window.addEventListener('resize', function() {
            if (window.innerWidth >= 1024) {
                closeSidebarFunc();
            }
        });

        // Close sidebar when pressing Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && sidebar.classList.contains('active')) {
                closeSidebarFunc();
            }
        });

        // Search functionality
        const searchInput = document.getElementById('searchOrders');
        const statusFilter = document.getElementById('statusFilter');
        const dateFilter = document.getElementById('dateFilter');
        const tableRows = document.querySelectorAll('tbody tr');

        function filterOrders() {
            const searchTerm = searchInput.value.toLowerCase();
            const statusValue = statusFilter.value;
            const dateValue = dateFilter.value;

            tableRows.forEach(row => {
                const orderId = row.cells[0].textContent.toLowerCase();
                const customerName = row.cells[1].textContent.toLowerCase();
                const orderDate = row.cells[2].textContent;
                const status = row.cells[3].textContent.trim();

                const matchesSearch = orderId.includes(searchTerm) || customerName.includes(searchTerm);
                const matchesStatus = !statusValue || status.toLowerCase().includes(statusValue.toLowerCase());
                const matchesDate = !dateValue || orderDate.includes(new Date(dateValue).toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' }));

                if (matchesSearch && matchesStatus && matchesDate) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        }

        // Add event listeners
        searchInput.addEventListener('input', filterOrders);
        statusFilter.addEventListener('change', filterOrders);
        dateFilter.addEventListener('change', filterOrders);

        // Add animation to stats cards on scroll
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -100px 0px'
        };

        const observer = new IntersectionObserver(function(entries) {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Initially hide elements for animation
        document.querySelectorAll('.grid > div').forEach(el => {
            el.style.opacity = '0';
            el.style.transform = 'translateY(20px)';
            el.style.transition = 'all 0.5s ease-out';
            observer.observe(el);
        });

        // Smooth scroll behavior
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });
    </script>
<?php require_once 'views/fotter-dashboard.php'; ?>