<?php 
include 'views/headin-dashboard.php';
?>
        <!-- Marketing Tools Content -->
        <main class="p-6">
            <!-- Header Section -->
            <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div>
                    <h1 class="text-3xl font-bold text-licorice mb-2">Marketing Tools 📈</h1>
                    <p class="text-gray-600">Manage marketing campaigns and tools</p>
                </div>
                <button class="btn-primary px-6 py-3 rounded-xl text-white font-semibold flex items-center justify-center gap-2 shadow-lg hover-lift">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                    </svg>
                    Create Campaign
                </button>
            </div>

            <!-- Marketing Stats -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-verdigris to-verdigris/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                            </svg>
                        </div>
                        <span class="text-verdigris text-sm font-semibold">Campaigns</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Active Campaigns</h3>
                    <p class="text-2xl font-bold text-licorice">8</p>
                </div>

                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-green-500 to-green-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                            </svg>
                        </div>
                        <span class="text-green-500 text-sm font-semibold">Views</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Total Views</h3>
                    <p class="text-2xl font-bold text-licorice">45,678</p>
                </div>

                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-hunyadi to-hunyadi/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-orange-500 text-sm font-semibold">Clicks</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Total Clicks</h3>
                    <p class="text-2xl font-bold text-licorice">2,340</p>
                </div>

                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-purple-500 text-sm font-semibold">ROI</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">ROI</h3>
                    <p class="text-2xl font-bold text-licorice">245%</p>
                </div>
            </div>

            <!-- Marketing Tools -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Email Marketing -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h3 class="text-lg font-bold text-licorice mb-4">Email Marketing</h3>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Newsletter Subscribers</span>
                            <span class="font-semibold">2,450</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Open Rate</span>
                            <span class="font-semibold">23.5%</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Click Rate</span>
                            <span class="font-semibold">4.2%</span>
                        </div>
                        <button class="w-full px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold hover:bg-verdigris/90 transition-colors">Create Campaign</button>
                    </div>
                </div>

                <!-- Social Media -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h3 class="text-lg font-bold text-licorice mb-4">Social Media</h3>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Facebook Followers</span>
                            <span class="font-semibold">1,234</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Instagram Followers</span>
                            <span class="font-semibold">856</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600">Twitter Followers</span>
                            <span class="font-semibold">432</span>
                        </div>
                        <button class="w-full px-4 py-2 bg-verdigris text-white rounded-lg text-sm font-semibold hover:bg-verdigris/90 transition-colors">Manage Posts</button>
                    </div>
                </div>
            </div>
        </main>

<?php require_once 'views/fotter-dashboard.php'; ?>
