-- Fix product_images table
-- Run this SQL if you're having issues with product images

-- Create product_images table if it doesn't exist
CREATE TABLE IF NOT EXISTS `product_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `image_url` varchar(255) NOT NULL,
  `image_alt` varchar(255) DEFAULT NULL,
  `is_primary` tinyint(1) DEFAULT 0,
  `sort_order` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `fk_product_images` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Check if table exists
SELECT 'product_images table is ready!' as status;

-- Show all product images
SELECT 
    pi.id,
    pi.product_id,
    p.product_name,
    pi.image_url,
    pi.is_primary,
    pi.sort_order
FROM product_images pi
LEFT JOIN products p ON pi.product_id = p.id
ORDER BY pi.product_id, pi.sort_order;
