# AmeasyShop Database & API Documentation

## 📦 Database Setup

### Step 1: Import SQL Files

1. Open **phpMyAdmin** in your browser: `http://localhost/phpmyadmin`
2. Select the database `ameasy` (or create it if it doesn't exist)
3. Click on the **Import** tab
4. Import the following files in order:
   - `database/users.sql` - Users and authentication
   - `database/categories.sql` - Product categories
   - `database/products.sql` - Products and inventory
5. Click **Go** to execute

### Step 2: Verify Tables

After importing, you should have these tables:
- ✅ `users` - Users, customers, and admins
- ✅ `categories` - Product categories with hierarchy
- ✅ `products` - Main products table
- ✅ `product_images` - Product images (linked to products)
- ✅ `product_reviews` - Customer reviews (optional)
- ✅ `product_variants` - Product variations like size/color (optional)

### Step 3: Sample Data

**Users** (Default password for all: `admin123`):
1. Admin User - admin@ameasyshop.com (Admin)
2. John Doe - john@example.com (Customer)
3. Jane Smith - jane@example.com (Customer)

**Categories** (9 parent categories + 6 subcategories):
1. Electronics
2. Clothing
3. Food & Beverage
4. Home & Kitchen
5. Sports & Outdoors
6. And more...

**Products** (3 sample products):
1. Wireless Bluetooth Headphones
2. Organic Cotton T-Shirt
3. Stainless Steel Water Bottle

---

## 🔌 API Endpoints

Base URL: `http://localhost/ameasyshop/api/products.php`

### Authentication

All requests require the API key in headers:
```
X-API-Key: 0Qwk2ndsNMijuJ2oGPYT
```

---

## 📋 API Methods

### 1. GET - Get All Products

**Request:**
```
GET /api/products.php
```

**Optional Query Parameters:**
- `page` - Page number (default: 1)
- `limit` - Items per page (default: 20)
- `search` - Search in name, SKU, brand
- `category` - Filter by category
- `status` - Filter by status (active, inactive, draft)
- `featured` - Filter featured products (yes, no)

**Example:**
```
GET /api/products.php?page=1&limit=10&category=electronics&status=active
```

**Response:**
```json
{
  "status": "success",
  "message": "Products retrieved successfully",
  "timestamp": "2025-10-08 12:00:00",
  "data": {
    "products": [...],
    "pagination": {
      "current_page": 1,
      "per_page": 10,
      "total": 25,
      "total_pages": 3
    }
  }
}
```

---

### 2. GET - Get Single Product

**Request:**
```
GET /api/products.php?id=1
```

**Response:**
```json
{
  "status": "success",
  "message": "Product retrieved successfully",
  "timestamp": "2025-10-08 12:00:00",
  "data": {
    "id": 1,
    "product_name": "Wireless Bluetooth Headphones",
    "sku": "WBH-001",
    "regular_price": "99.99",
    "sale_price": "79.99",
    "stock_quantity": 50,
    "images": ["image1.jpg", "image2.jpg"],
    ...
  }
}
```

---

### 3. POST - Create Product

**Request:**
```
POST /api/products.php
Content-Type: application/json
```

**Required Fields:**
- `product_name`
- `sku`
- `category`
- `regular_price`
- `stock_quantity`

**Example Body:**
```json
{
  "product_name": "Wireless Mouse",
  "sku": "WM-001",
  "brand": "TechGear",
  "category": "electronics",
  "subcategory": "Accessories",
  "short_description": "Ergonomic wireless mouse",
  "description": "Full product description here...",
  "regular_price": 29.99,
  "sale_price": 24.99,
  "cost_price": 15.00,
  "stock_quantity": 100,
  "low_stock_alert": 10,
  "stock_status": "in_stock",
  "weight": 0.15,
  "color": "Black",
  "warranty": "1 year",
  "meta_title": "Best Wireless Mouse 2025",
  "meta_description": "Buy the best wireless mouse...",
  "tags": "mouse, wireless, ergonomic",
  "status": "active",
  "featured": "no",
  "show_homepage": 0,
  "allow_reviews": 1
}
```

**Response:**
```json
{
  "status": "success",
  "message": "Product created successfully",
  "timestamp": "2025-10-08 12:00:00",
  "data": {
    "product_id": 4
  }
}
```

---

### 4. PUT - Update Product

**Request:**
```
PUT /api/products.php?id=1
Content-Type: application/json
```

**Example Body:** (only include fields to update)
```json
{
  "regular_price": 89.99,
  "sale_price": 69.99,
  "stock_quantity": 45,
  "status": "active"
}
```

**Response:**
```json
{
  "status": "success",
  "message": "Product updated successfully",
  "timestamp": "2025-10-08 12:00:00",
  "data": {
    "product_id": 1
  }
}
```

---

### 5. DELETE - Delete Product

**Request:**
```
DELETE /api/products.php?id=1
```

**Response:**
```json
{
  "status": "success",
  "message": "Product deleted successfully",
  "timestamp": "2025-10-08 12:00:00"
}
```

---

## 👥 CUSTOMERS API

Base URL: `http://localhost/ameasyshop/api/customers.php`

### 1. GET - Get All Customers

**Request:**
```
GET /api/customers.php
```

**Optional Query Parameters:**
- `role` - Filter by role (admin, customer)
- `status` - Filter by status (active, inactive)
- `search` - Search in name, email, or phone

**Example:**
```
GET /api/customers.php?role=customer&status=active
```

**Response:**
```json
{
  "status": "success",
  "message": "Customers retrieved successfully",
  "timestamp": "2025-10-08 12:00:00",
  "data": {
    "customers": [...],
    "total": 25
  }
}
```

---

### 2. GET - Get Single Customer

**Request:**
```
GET /api/customers.php?id=1
```

**Response:**
```json
{
  "status": "success",
  "message": "Customer retrieved successfully",
  "timestamp": "2025-10-08 12:00:00",
  "data": {
    "id": 1,
    "name": "John Doe",
    "email": "john@example.com",
    "phone_number": "+1234567890",
    "role": "customer",
    "status": "active",
    ...
  }
}
```

---

### 3. POST - Create Customer

**Request:**
```
POST /api/customers.php
Content-Type: application/json
```

**Required Fields:**
- `name`
- `email`
- `password` (min. 6 characters)

**Example Body:**
```json
{
  "name": "John Doe",
  "email": "john@example.com",
  "password": "secure123",
  "phone_number": "+1234567890",
  "role": "customer",
  "nation_code": "1234567890",
  "place": "New York",
  "adress": "123 Main St",
  "status": "active"
}
```

**Response:**
```json
{
  "status": "success",
  "message": "Customer created successfully",
  "timestamp": "2025-10-08 12:00:00",
  "data": {
    "customer_id": 4
  }
}
```

---

### 4. PUT - Update Customer

**Request:**
```
PUT /api/customers.php?id=1
Content-Type: application/json
```

**Example Body:** (only include fields to update)
```json
{
  "name": "John Smith",
  "phone_number": "+9876543210",
  "role": "admin",
  "status": "active"
}
```

**Note:** Password field is optional when updating. Leave blank to keep current password.

**Response:**
```json
{
  "status": "success",
  "message": "Customer updated successfully",
  "timestamp": "2025-10-08 12:00:00",
  "data": {
    "customer_id": 1
  }
}
```

---

### 5. DELETE - Delete Customer

**Request:**
```
DELETE /api/customers.php?id=1
```

**Note:** Only admins can delete customers. You cannot delete your own account.

**Response:**
```json
{
  "status": "success",
  "message": "Customer deleted successfully",
  "timestamp": "2025-10-08 12:00:00"
}
```

---

### Users Table Structure

| Field | Type | Description |
|-------|------|-------------|
| id | INT | Primary key |
| name | VARCHAR(100) | Customer name |
| email | VARCHAR(150) | Unique email (used for login) |
| phone_number | VARCHAR(20) | Phone number |
| password | VARCHAR(255) | Hashed password |
| role | ENUM | admin/customer |
| nation_code | VARCHAR(20) | National ID |
| avatar | VARCHAR(255) | Profile picture path |
| place | VARCHAR(100) | City/Location |
| adress | TEXT | Full address |
| status | ENUM | active/inactive |
| created_at | TIMESTAMP | Registration date |
| updated_at | TIMESTAMP | Last update |

---

## 🔧 Testing with Postman

### Step 1: Create New Request
1. Open Postman
2. Create new request
3. Set method (GET, POST, PUT, DELETE)
4. Enter URL: `http://localhost/ameasyshop/api/products.php`

### Step 2: Add Headers
```
Content-Type: application/json
X-API-Key: 0Qwk2ndsNMijuJ2oGPYT
```

### Step 3: Add Body (for POST/PUT)
- Select **Body** tab
- Choose **raw** and **JSON**
- Paste JSON data

### Step 4: Send Request
Click **Send** and view response

---

## 🔐 Security Notes

1. **API Key**: Change the default API key in `controlls/functions.php`
2. **Authentication**: All CREATE/UPDATE/DELETE operations require user login
3. **Input Validation**: API validates all required fields
4. **SQL Injection Protection**: All queries use prepared statements
5. **XSS Protection**: Data is properly escaped

---

## 📊 Database Schema

### Products Table Structure

| Field | Type | Description |
|-------|------|-------------|
| id | INT | Primary key |
| product_name | VARCHAR(255) | Product name |
| slug | VARCHAR(255) | URL-friendly name |
| sku | VARCHAR(100) | Unique product code |
| brand | VARCHAR(100) | Brand name |
| category | VARCHAR(100) | Main category |
| subcategory | VARCHAR(100) | Sub category |
| regular_price | DECIMAL(10,2) | Regular price |
| sale_price | DECIMAL(10,2) | Sale price |
| stock_quantity | INT | Current stock |
| status | ENUM | active/inactive/draft |
| created_at | TIMESTAMP | Creation date |
| updated_at | TIMESTAMP | Last update |

---

## 🚀 Quick Start

1. **Import Database:**
   ```sql
   -- In phpMyAdmin, import these files in order:
   -- 1. users.sql
   -- 2. categories.sql
   -- 3. products.sql
   ```

2. **Test APIs:**
   ```bash
   # Get all customers
   curl -X GET "http://localhost/ameasyshop/api/customers.php" \
        -H "X-API-Key: 0Qwk2ndsNMijuJ2oGPYT"
   
   # Get all products
   curl -X GET "http://localhost/ameasyshop/api/products.php" \
        -H "X-API-Key: 0Qwk2ndsNMijuJ2oGPYT"
   
   # Get all categories
   curl -X GET "http://localhost/ameasyshop/api/categories.php" \
        -H "X-API-Key: 0Qwk2ndsNMijuJ2oGPYT"
   ```

3. **Access Management Pages:**
   - **Customers:** `http://localhost/ameasyshop/customers.php`
   - **Categories:** `http://localhost/ameasyshop/categories.php`
   - **Products:** `http://localhost/ameasyshop/products.php`
   - **Add Product:** `http://localhost/ameasyshop/add-product.php`

---

## 🐛 Troubleshooting

### Error: "Invalid or missing API key"
- Make sure to include `X-API-Key` header in all requests
- Check if API key matches in `controlls/functions.php`

### Error: "Authentication required"
- You must be logged in to CREATE/UPDATE/DELETE
- Only GET requests work without login

### Error: "Database error"
- Check database connection in `controlls/functions.php`
- Make sure `ameasy` database exists
- Verify tables are imported correctly

### Error: "SKU already exists"
- Each product must have a unique SKU
- Check if SKU is already in use

---

## 📞 Support

For issues or questions, check:
- Database connection: `controlls/functions.php`
- API endpoint: `api/products.php`
- Frontend form: `add-product.php`

---

**Created by:** AmeasyShop Team  
**Version:** 1.0  
**Last Updated:** October 2025
