<?php 
include 'views/headin-dashboard.php';
?>
        <!-- Customers Management Page -->
        <main class="p-6">
            <!-- Header Section -->
            <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div>
                    <h1 class="text-3xl font-bold text-licorice mb-2">Customers Management 👥</h1>
                    <p class="text-gray-600">Manage your customers and user accounts</p>
                </div>
                <button id="addCustomerBtn" class="btn-primary px-6 py-3 rounded-xl text-white font-semibold flex items-center justify-center gap-2 shadow-lg hover-lift">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                    </svg>
                    Add New Customer
                </button>
            </div>

            <!-- Filter Section -->
            <div class="bg-white rounded-xl shadow-md p-4 mb-6">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <!-- Search -->
                    <div class="md:col-span-2">
                        <input type="text" id="searchInput" 
                            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            placeholder="Search by name, email or phone...">
                    </div>
                    
                    <!-- Role Filter -->
                    <div>
                        <select id="roleFilter" 
                            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all">
                            <option value="">All Roles</option>
                            <option value="admin">Admin</option>
                            <option value="customer">Customer</option>
                        </select>
                    </div>
                    
                    <!-- Status Filter -->
                    <div>
                        <select id="statusFilter" 
                            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all">
                            <option value="">All Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
                <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl shadow-lg p-6 text-white">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-blue-100 text-sm mb-1">Total Customers</p>
                            <h3 id="totalCustomers" class="text-3xl font-bold">0</h3>
                        </div>
                        <div class="text-4xl opacity-50">👥</div>
                    </div>
                </div>
                
                <div class="bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl shadow-lg p-6 text-white">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-purple-100 text-sm mb-1">Admins</p>
                            <h3 id="totalAdmins" class="text-3xl font-bold">0</h3>
                        </div>
                        <div class="text-4xl opacity-50">👑</div>
                    </div>
                </div>
                
                <div class="bg-gradient-to-br from-green-500 to-green-600 rounded-xl shadow-lg p-6 text-white">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-green-100 text-sm mb-1">Active Users</p>
                            <h3 id="activeUsers" class="text-3xl font-bold">0</h3>
                        </div>
                        <div class="text-4xl opacity-50">✅</div>
                    </div>
                </div>
                
                <div class="bg-gradient-to-br from-orange-500 to-orange-600 rounded-xl shadow-lg p-6 text-white">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-orange-100 text-sm mb-1">New This Month</p>
                            <h3 id="newUsers" class="text-3xl font-bold">0</h3>
                        </div>
                        <div class="text-4xl opacity-50">🆕</div>
                    </div>
                </div>
            </div>

            <!-- Customers Table -->
            <div class="bg-white rounded-xl shadow-lg overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b border-gray-200">
                            <tr>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">ID</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Name</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Email</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Phone</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Role</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Created</th>
                                <th class="px-6 py-4 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody id="customersTable" class="divide-y divide-gray-200">
                            <!-- Loading State -->
                            <tr>
                                <td colspan="8" class="px-6 py-20 text-center">
                                    <svg class="animate-spin w-12 h-12 mx-auto text-verdigris mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                    </svg>
                                    <p class="text-gray-600">Loading customers...</p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>

        <!-- Add/Edit Customer Modal -->
        <div id="customerModal" class="fixed inset-0 bg-black/50 z-50 hidden flex items-center justify-center p-4">
            <div class="bg-white rounded-2xl shadow-2xl max-w-2xl w-full max-h-[90vh] overflow-y-auto">
                <div class="p-6 border-b border-gray-200 flex items-center justify-between">
                    <h2 id="modalTitle" class="text-2xl font-bold text-licorice">Add New Customer</h2>
                    <button id="closeModal" class="text-gray-400 hover:text-gray-600 transition-colors">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
                
                <form id="customerForm" class="p-6 space-y-6">
                    <input type="hidden" id="customerId" name="id">
                    
                    <!-- Customer Name -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Full Name <span class="text-red-500">*</span>
                        </label>
                        <input type="text" id="customerName" name="name" required
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            placeholder="Enter full name">
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Email -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Email <span class="text-red-500">*</span>
                            </label>
                            <input type="email" id="customerEmail" name="email" required
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                                placeholder="email@example.com">
                        </div>

                        <!-- Phone Number -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Phone Number</label>
                            <input type="text" id="customerPhone" name="phone_number"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                                placeholder="+1234567890">
                        </div>
                    </div>

                    <!-- Password (Only for new customers or when changing) -->
                    <div id="passwordField">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Password <span class="text-red-500" id="passwordRequired">*</span>
                        </label>
                        <input type="password" id="customerPassword" name="password"
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            placeholder="Min. 6 characters">
                        <p class="text-xs text-gray-500 mt-1" id="passwordHint">Password must be at least 6 characters</p>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Role -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Role</label>
                            <select id="customerRole" name="role"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all">
                                <option value="customer">Customer</option>
                                <option value="admin">Admin</option>
                            </select>
                        </div>

                        <!-- Status -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Status</label>
                            <select id="customerStatus" name="status"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all">
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- National Code -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">National Code</label>
                            <input type="text" id="customerNationCode" name="nation_code"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                                placeholder="National ID">
                        </div>

                        <!-- Place -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">City/Place</label>
                            <input type="text" id="customerPlace" name="place"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                                placeholder="City">
                        </div>
                    </div>

                    <!-- Address -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">Address</label>
                        <textarea id="customerAddress" name="adress" rows="3"
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all resize-none"
                            placeholder="Full address"></textarea>
                    </div>

                    <!-- Form Actions -->
                    <div class="flex items-center justify-end gap-4 pt-4 border-t border-gray-200">
                        <button type="button" id="cancelBtn" class="px-6 py-3 border-2 border-gray-300 text-gray-700 rounded-xl font-semibold hover:bg-gray-50 transition-all">
                            Cancel
                        </button>
                        <button type="submit" class="btn-primary px-8 py-3 rounded-xl text-white font-semibold shadow-lg hover-lift">
                            Save Customer
                        </button>
                    </div>
                </form>
            </div>
        </div>

    <script>
        // Mobile offcanvas menu
        const menuToggle = document.getElementById('menuToggle');
        const closeSidebar = document.getElementById('closeSidebar');
        const sidebar = document.getElementById('sidebar');
        const sidebarBackdrop = document.getElementById('sidebarBackdrop');

        function openSidebar() {
            sidebar.classList.add('active');
            sidebarBackdrop.classList.add('active');
            document.body.style.overflow = 'hidden';
        }

        function closeSidebarFunc() {
            sidebar.classList.remove('active');
            sidebarBackdrop.classList.remove('active');
            document.body.style.overflow = '';
        }

        menuToggle.addEventListener('click', function() {
            sidebar.classList.contains('active') ? closeSidebarFunc() : openSidebar();
        });

        closeSidebar.addEventListener('click', closeSidebarFunc);
        sidebarBackdrop.addEventListener('click', closeSidebarFunc);

        window.addEventListener('resize', function() {
            if (window.innerWidth >= 1024) closeSidebarFunc();
        });

        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && sidebar.classList.contains('active')) closeSidebarFunc();
        });

        // Modal Management
        const modal = document.getElementById('customerModal');
        const addCustomerBtn = document.getElementById('addCustomerBtn');
        const closeModal = document.getElementById('closeModal');
        const cancelBtn = document.getElementById('cancelBtn');
        const customerForm = document.getElementById('customerForm');
        let editMode = false;
        let allCustomers = [];

        function openModal(customer = null) {
            editMode = !!customer;
            document.getElementById('modalTitle').textContent = editMode ? 'Edit Customer' : 'Add New Customer';
            
            if (editMode) {
                document.getElementById('customerId').value = customer.id;
                document.getElementById('customerName').value = customer.name;
                document.getElementById('customerEmail').value = customer.email;
                document.getElementById('customerPhone').value = customer.phone_number || '';
                document.getElementById('customerRole').value = customer.role;
                document.getElementById('customerStatus').value = customer.status;
                document.getElementById('customerNationCode').value = customer.nation_code || '';
                document.getElementById('customerPlace').value = customer.place || '';
                document.getElementById('customerAddress').value = customer.adress || '';
                
                // Make password optional when editing
                document.getElementById('customerPassword').required = false;
                document.getElementById('passwordRequired').style.display = 'none';
                document.getElementById('passwordHint').textContent = 'Leave blank to keep current password';
            } else {
                customerForm.reset();
                document.getElementById('customerId').value = '';
                document.getElementById('customerPassword').required = true;
                document.getElementById('passwordRequired').style.display = 'inline';
                document.getElementById('passwordHint').textContent = 'Password must be at least 6 characters';
            }
            
            modal.classList.remove('hidden');
            document.body.style.overflow = 'hidden';
        }

        function closeModalFunc() {
            modal.classList.add('hidden');
            document.body.style.overflow = '';
            customerForm.reset();
        }

        addCustomerBtn.addEventListener('click', () => openModal());
        closeModal.addEventListener('click', closeModalFunc);
        cancelBtn.addEventListener('click', closeModalFunc);

        // Close modal on backdrop click
        modal.addEventListener('click', function(e) {
            if (e.target === modal) closeModalFunc();
        });

        // Load Customers
        function loadCustomers() {
            const searchQuery = document.getElementById('searchInput').value;
            const roleFilter = document.getElementById('roleFilter').value;
            const statusFilter = document.getElementById('statusFilter').value;
            
            let url = 'api/customers.php?';
            if (searchQuery) url += `search=${encodeURIComponent(searchQuery)}&`;
            if (roleFilter) url += `role=${roleFilter}&`;
            if (statusFilter) url += `status=${statusFilter}&`;
            
            fetch(url, {
                method: 'GET'
            })
            .then(response => response.json())
            .then(data => {
                console.log('API Response:', data);
                if (data.success === true && data.data.customers.length > 0) {
                    allCustomers = data.data.customers;
                    displayCustomers(data.data.customers);
                    updateStatistics(data.data.customers);
                } else {
                    showEmptyState();
                    updateStatistics([]);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showErrorState();
            });
        }

        // Display Customers
        function displayCustomers(customers) {
            const tbody = document.getElementById('customersTable');
            let html = '';
            
            customers.forEach(customer => {
                const statusBadge = customer.status === 'active' 
                    ? '<span class="px-2 py-1 bg-green-100 text-green-700 rounded-full text-xs font-semibold">Active</span>'
                    : '<span class="px-2 py-1 bg-gray-100 text-gray-700 rounded-full text-xs font-semibold">Inactive</span>';
                
                const roleBadge = customer.role === 'admin'
                    ? '<span class="px-2 py-1 bg-purple-100 text-purple-700 rounded-full text-xs font-semibold flex items-center gap-1"><span>👑</span>Admin</span>'
                    : '<span class="px-2 py-1 bg-blue-100 text-blue-700 rounded-full text-xs font-semibold">Customer</span>';
                
                const createdDate = new Date(customer.created_at).toLocaleDateString('en-US', {
                    year: 'numeric',
                    month: 'short',
                    day: 'numeric'
                });
                
                html += `
                    <tr class="hover:bg-gray-50 transition-colors">
                        <td class="px-6 py-4 text-sm font-medium text-gray-900">#${customer.id}</td>
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <div class="w-10 h-10 rounded-full bg-gradient-to-br from-hunyadi to-verdigris flex items-center justify-center text-white font-bold mr-3">
                                    ${customer.name.charAt(0).toUpperCase()}
                                </div>
                                <div class="text-sm font-semibold text-gray-900">${customer.name}</div>
                            </div>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">${customer.email}</td>
                        <td class="px-6 py-4 text-sm text-gray-600">${customer.phone_number || '-'}</td>
                        <td class="px-6 py-4">${roleBadge}</td>
                        <td class="px-6 py-4">${statusBadge}</td>
                        <td class="px-6 py-4 text-sm text-gray-600">${createdDate}</td>
                        <td class="px-6 py-4">
                            <div class="flex items-center gap-2">
                                <button onclick="editCustomer(${customer.id})" class="p-2 bg-blue-500 text-white rounded-lg hover:bg-blue-600 transition-colors" title="Edit">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                    </svg>
                                </button>
                                <button onclick="deleteCustomer(${customer.id}, '${customer.name}')" class="p-2 bg-red-500 text-white rounded-lg hover:bg-red-600 transition-colors" title="Delete">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                    </svg>
                                </button>
                            </div>
                        </td>
                    </tr>
                `;
            });
            
            tbody.innerHTML = html;
        }

        // Update Statistics
        function updateStatistics(customers) {
            const total = customers.length;
            const admins = customers.filter(c => c.role === 'admin').length;
            const active = customers.filter(c => c.status === 'active').length;
            
            // Calculate new users this month
            const now = new Date();
            const thisMonthStart = new Date(now.getFullYear(), now.getMonth(), 1);
            const newThisMonth = customers.filter(c => new Date(c.created_at) >= thisMonthStart).length;
            
            document.getElementById('totalCustomers').textContent = total;
            document.getElementById('totalAdmins').textContent = admins;
            document.getElementById('activeUsers').textContent = active;
            document.getElementById('newUsers').textContent = newThisMonth;
        }

        // Show Empty State
        function showEmptyState() {
            document.getElementById('customersTable').innerHTML = `
                <tr>
                    <td colspan="8" class="px-6 py-20 text-center">
                        <svg class="w-24 h-24 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                        <h3 class="text-xl font-semibold text-gray-600 mb-2">No Customers Found</h3>
                        <p class="text-gray-500 mb-6">Get started by adding your first customer</p>
                        <button onclick="openModal()" class="btn-primary px-6 py-3 rounded-xl text-white font-semibold inline-flex items-center gap-2 shadow-lg">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                            </svg>
                            Add First Customer
                        </button>
                    </td>
                </tr>
            `;
        }

        // Show Error State
        function showErrorState() {
            document.getElementById('customersTable').innerHTML = `
                <tr>
                    <td colspan="8" class="px-6 py-20 text-center text-red-500">
                        Error loading customers
                    </td>
                </tr>
            `;
        }

        // Form Submission
        customerForm.addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<svg class="animate-spin w-5 h-5 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Saving...';
            
            const formData = new FormData(this);
            const customerData = {
                name: formData.get('name'),
                email: formData.get('email'),
                phone_number: formData.get('phone_number') || null,
                role: formData.get('role'),
                status: formData.get('status'),
                nation_code: formData.get('nation_code') || null,
                place: formData.get('place') || null,
                adress: formData.get('adress') || null
            };
            
            // Only include password if it's provided
            const password = formData.get('password');
            if (password) {
                customerData.password = password;
            }
            
            const customerId = document.getElementById('customerId').value;
            const url = editMode ? `api/customers.php?id=${customerId}` : 'api/customers.php';
            const method = editMode ? 'PUT' : 'POST';
            
            try {
                const response = await fetch(url, {
                    method: method,
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(customerData)
                });
                
                const data = await response.json();
                console.log('Save Response:', data);
                
                if (data.success === true) {
                    showNotification('success', editMode ? 'Customer updated successfully!' : 'Customer created successfully!');
                    closeModalFunc();
                    loadCustomers();
                } else {
                    throw new Error(data.message);
                }
            } catch (error) {
                showNotification('error', error.message || 'Operation failed');
            }
            
            submitBtn.disabled = false;
            submitBtn.innerHTML = originalText;
        });

        // Edit Customer
        async function editCustomer(id) {
            try {
                const response = await fetch(`api/customers.php?id=${id}`, {
                    method: 'GET'
                });
                
                const data = await response.json();
                console.log('Edit Response:', data);
                
                if (data.success === true) {
                    openModal(data.data);
                } else {
                    throw new Error(data.message);
                }
            } catch (error) {
                showNotification('error', 'Failed to load customer');
            }
        }

        // Delete Customer
        async function deleteCustomer(id, name) {
            if (!confirm(`Are you sure you want to delete "${name}"? This action cannot be undone.`)) {
                return;
            }
            
            try {
                const response = await fetch(`api/customers.php?id=${id}`, {
                    method: 'DELETE'
                });
                
                const data = await response.json();
                console.log('Delete Response:', data);
                
                if (data.success === true) {
                    showNotification('success', 'Customer deleted successfully!');
                    loadCustomers();
                } else {
                    throw new Error(data.message);
                }
            } catch (error) {
                showNotification('error', error.message || 'Failed to delete customer');
            }
        }

        // Notification Function
        function showNotification(type, message) {
            const notification = document.createElement('div');
            notification.className = `notification ${type} show`;
            notification.innerHTML = `
                <div class="flex items-center">
                    <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        ${type === 'success' 
                            ? '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>'
                            : '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>'
                        }
                    </svg>
                    <span>${message}</span>
                </div>
            `;
            document.body.appendChild(notification);
            
            setTimeout(() => {
                notification.remove();
            }, 5000);
        }

        // Filter Event Listeners
        document.getElementById('searchInput').addEventListener('input', debounce(loadCustomers, 500));
        document.getElementById('roleFilter').addEventListener('change', loadCustomers);
        document.getElementById('statusFilter').addEventListener('change', loadCustomers);

        // Debounce function for search
        function debounce(func, wait) {
            let timeout;
            return function executedFunction(...args) {
                const later = () => {
                    clearTimeout(timeout);
                    func(...args);
                };
                clearTimeout(timeout);
                timeout = setTimeout(later, wait);
            };
        }

        // Load customers on page load
        loadCustomers();
    </script>
<?php require_once 'views/fotter-dashboard.php'; ?>
