<?php 
include 'views/headin-dashboard.php';
?>
        <!-- Analytics Dashboard Content -->
        <main class="p-6">
            <!-- Header Section -->
            <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div>
                    <h1 class="text-3xl font-bold text-licorice mb-2">Analytics Dashboard 📊</h1>
                    <p class="text-gray-600">Comprehensive insights into your store's performance</p>
                </div>
                <div class="flex gap-3">
                    <select class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all">
                        <option value="7">Last 7 days</option>
                        <option value="30">Last 30 days</option>
                        <option value="90">Last 90 days</option>
                        <option value="365">Last year</option>
                    </select>
                    <button class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg font-semibold hover:bg-gray-50 transition-colors">
                        Export Report
                    </button>
                </div>
            </div>

            <!-- Key Metrics -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
                <!-- Total Revenue -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-verdigris to-verdigris/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <span class="text-green-500 text-sm font-semibold">+12.5%</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Total Revenue</h3>
                    <p class="text-2xl font-bold text-licorice">$45,678</p>
                </div>

                <!-- Total Orders -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-green-500 to-green-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                            </svg>
                        </div>
                        <span class="text-green-500 text-sm font-semibold">+8.3%</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Total Orders</h3>
                    <p class="text-2xl font-bold text-licorice">1,234</p>
                </div>

                <!-- Average Order Value -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-hunyadi to-hunyadi/80 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                            </svg>
                        </div>
                        <span class="text-orange-500 text-sm font-semibold">+5.2%</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Average Order Value</h3>
                    <p class="text-2xl font-bold text-licorice">$37.02</p>
                </div>

                <!-- Conversion Rate -->
                <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-xl transition-shadow duration-300">
                    <div class="flex items-center justify-between mb-4">
                        <div class="p-3 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                            </svg>
                        </div>
                        <span class="text-purple-500 text-sm font-semibold">+2.1%</span>
                    </div>
                    <h3 class="text-gray-500 text-sm mb-1">Conversion Rate</h3>
                    <p class="text-2xl font-bold text-licorice">3.24%</p>
                </div>
            </div>

            <!-- Charts Section -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
                <!-- Revenue Chart -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-6">
                        <h2 class="text-xl font-bold text-licorice">Revenue Trend</h2>
                        <div class="flex gap-2">
                            <button class="px-3 py-1 bg-verdigris text-white rounded-lg text-sm font-semibold">Daily</button>
                            <button class="px-3 py-1 border border-gray-300 text-gray-700 rounded-lg text-sm font-semibold hover:bg-gray-50">Weekly</button>
                            <button class="px-3 py-1 border border-gray-300 text-gray-700 rounded-lg text-sm font-semibold hover:bg-gray-50">Monthly</button>
                        </div>
                    </div>
                    <div class="h-64 flex items-center justify-center bg-gray-50 rounded-lg">
                        <div class="text-center">
                            <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                            </svg>
                            <p class="text-gray-500">Revenue chart will be displayed here</p>
                        </div>
                    </div>
                </div>

                <!-- Orders Chart -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-6">
                        <h2 class="text-xl font-bold text-licorice">Orders Overview</h2>
                        <div class="flex gap-2">
                            <button class="px-3 py-1 bg-verdigris text-white rounded-lg text-sm font-semibold">Orders</button>
                            <button class="px-3 py-1 border border-gray-300 text-gray-700 rounded-lg text-sm font-semibold hover:bg-gray-50">Visitors</button>
                        </div>
                    </div>
                    <div class="h-64 flex items-center justify-center bg-gray-50 rounded-lg">
                        <div class="text-center">
                            <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 8v8m-4-5v5m-4-2v2m-2 4h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                            <p class="text-gray-500">Orders chart will be displayed here</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Top Products & Categories -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
                <!-- Top Selling Products -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-6">
                        <h2 class="text-xl font-bold text-licorice">Top Selling Products</h2>
                        <button class="text-verdigris hover:text-seal-brown transition-colors text-sm font-semibold">View All</button>
                    </div>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 bg-gradient-to-br from-verdigris to-hunyadi rounded-lg flex items-center justify-center text-white font-bold text-sm">1</div>
                                <div>
                                    <div class="font-semibold text-sm">Wireless Headphones</div>
                                    <div class="text-xs text-gray-500">Electronics</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="font-bold text-sm">234 sales</div>
                                <div class="text-xs text-gray-500">$11,700</div>
                            </div>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 bg-gradient-to-br from-hunyadi to-seal-brown rounded-lg flex items-center justify-center text-white font-bold text-sm">2</div>
                                <div>
                                    <div class="font-semibold text-sm">Smart Watch</div>
                                    <div class="text-xs text-gray-500">Electronics</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="font-bold text-sm">189 sales</div>
                                <div class="text-xs text-gray-500">$9,450</div>
                            </div>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 bg-gradient-to-br from-seal-brown to-licorice rounded-lg flex items-center justify-center text-white font-bold text-sm">3</div>
                                <div>
                                    <div class="font-semibold text-sm">Cotton T-Shirt</div>
                                    <div class="text-xs text-gray-500">Clothing</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="font-bold text-sm">156 sales</div>
                                <div class="text-xs text-gray-500">$3,900</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sales by Category -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex items-center justify-between mb-6">
                        <h2 class="text-xl font-bold text-licorice">Sales by Category</h2>
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                        </svg>
                    </div>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-4 h-4 bg-verdigris rounded"></div>
                                <span class="font-semibold text-sm">Electronics</span>
                            </div>
                            <div class="text-right">
                                <div class="font-bold text-sm">45%</div>
                                <div class="text-xs text-gray-500">$20,556</div>
                            </div>
                        </div>
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-4 h-4 bg-hunyadi rounded"></div>
                                <span class="font-semibold text-sm">Clothing</span>
                            </div>
                            <div class="text-right">
                                <div class="font-bold text-sm">30%</div>
                                <div class="text-xs text-gray-500">$13,704</div>
                            </div>
                        </div>
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-4 h-4 bg-seal-brown rounded"></div>
                                <span class="font-semibold text-sm">Home & Garden</span>
                            </div>
                            <div class="text-right">
                                <div class="font-bold text-sm">15%</div>
                                <div class="text-xs text-gray-500">$6,852</div>
                            </div>
                        </div>
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="w-4 h-4 bg-licorice rounded"></div>
                                <span class="font-semibold text-sm">Sports</span>
                            </div>
                            <div class="text-right">
                                <div class="font-bold text-sm">10%</div>
                                <div class="text-xs text-gray-500">$4,568</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Traffic Sources -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-xl font-bold text-licorice">Traffic Sources</h2>
                    <div class="flex gap-2">
                        <button class="px-3 py-1 bg-verdigris text-white rounded-lg text-sm font-semibold">Sources</button>
                        <button class="px-3 py-1 border border-gray-300 text-gray-700 rounded-lg text-sm font-semibold hover:bg-gray-50">Devices</button>
                        <button class="px-3 py-1 border border-gray-300 text-gray-700 rounded-lg text-sm font-semibold hover:bg-gray-50">Locations</button>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div class="text-center">
                        <div class="w-20 h-20 bg-gradient-to-br from-verdigris to-hunyadi rounded-full flex items-center justify-center mx-auto mb-3">
                            <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9v-9m0-9v9"/>
                            </svg>
                        </div>
                        <h3 class="font-bold text-lg text-licorice">Organic Search</h3>
                        <p class="text-2xl font-bold text-verdigris">45%</p>
                        <p class="text-sm text-gray-500">2,340 visitors</p>
                    </div>
                    <div class="text-center">
                        <div class="w-20 h-20 bg-gradient-to-br from-hunyadi to-seal-brown rounded-full flex items-center justify-center mx-auto mb-3">
                            <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                            </svg>
                        </div>
                        <h3 class="font-bold text-lg text-licorice">Social Media</h3>
                        <p class="text-2xl font-bold text-hunyadi">30%</p>
                        <p class="text-sm text-gray-500">1,560 visitors</p>
                    </div>
                    <div class="text-center">
                        <div class="w-20 h-20 bg-gradient-to-br from-seal-brown to-licorice rounded-full flex items-center justify-center mx-auto mb-3">
                            <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                            </svg>
                        </div>
                        <h3 class="font-bold text-lg text-licorice">Direct Traffic</h3>
                        <p class="text-2xl font-bold text-seal-brown">25%</p>
                        <p class="text-sm text-gray-500">1,300 visitors</p>
                    </div>
                </div>
            </div>
        </main>

<?php require_once 'views/fotter-dashboard.php'; ?>
