<?php 
include 'views/headin-dashboard.php';
?>
        <!-- Add Product Page Content -->
        <main class="p-6">
            <!-- Header Section -->
            <div class="mb-6">
                <div class="flex items-center gap-3 mb-2">
                    <a href="products" class="text-gray-600 hover:text-verdigris transition-colors">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                        </svg>
                    </a>
                    <h1 class="text-3xl font-bold text-licorice">Add New Product</h1>
                </div>
                <p class="text-gray-600">Fill in the information below to create a new product</p>
            </div>

            <form id="addProductForm" class="space-y-6">
                <!-- Basic Information -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h2 class="text-xl font-bold text-licorice mb-6 flex items-center gap-2">
                        <svg class="w-6 h-6 text-verdigris" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Basic Information
                    </h2>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Product Name -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Product Name <span class="text-red-500">*</span>
                            </label>
                            <input 
                                type="text" 
                                name="product_name" 
                                placeholder="Enter product name" 
                                required
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Brand -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Brand</label>
                            <input 
                                type="text" 
                                name="brand" 
                                placeholder="Enter brand name" 
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- SKU -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                SKU <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <input 
                                    type="text" 
                                    name="sku" 
                                    placeholder="e.g., PROD-001" 
                                    required
                                    class="w-full px-4 py-3 pr-12 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                                >
                                <button 
                                    type="button" 
                                    onclick="generateAIContent('sku')"
                                    class="absolute right-2 top-1/2 transform -translate-y-1/2 bg-blue-500 hover:bg-blue-600 text-white p-2 rounded-lg transition-colors"
                                    title="Generate SKU with AI"
                                >
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <!-- Category -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Category <span class="text-red-500">*</span>
                            </label>
                            <select 
                                name="category" 
                                required
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                                <option value="">Select category</option>
                                <option value="electronics">Electronics</option>
                                <option value="clothing">Clothing</option>
                                <option value="food">Food & Beverage</option>
                                <option value="home">Home & Kitchen</option>
                                <option value="sports">Sports & Outdoors</option>
                                <option value="toys">Toys & Games</option>
                                <option value="books">Books & Media</option>
                                <option value="beauty">Beauty & Personal Care</option>
                                <option value="other">Other</option>
                            </select>
                        </div>

                        <!-- Subcategory -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Subcategory</label>
                            <input 
                                type="text" 
                                name="subcategory" 
                                placeholder="Enter subcategory" 
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Short Description -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Short Description</label>
                            <div class="relative">
                                <input 
                                    type="text" 
                                    name="short_description" 
                                    placeholder="Brief description (max 160 characters)" 
                                    maxlength="160"
                                    class="w-full px-4 py-3 pr-12 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                                >
                                <button 
                                    type="button" 
                                    onclick="generateAIContent('short_description')"
                                    class="absolute right-2 top-1/2 transform -translate-y-1/2 bg-blue-500 hover:bg-blue-600 text-white p-2 rounded-lg transition-colors"
                                    title="Generate Short Description with AI"
                                >
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <!-- Full Description -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Full Description</label>
                            <div class="relative">
                                <textarea 
                                    name="description" 
                                    rows="5" 
                                    placeholder="Detailed product description"
                                    class="w-full px-4 py-3 pr-12 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all resize-none"
                                ></textarea>
                                <button 
                                    type="button" 
                                    onclick="generateAIContent('description')"
                                    class="absolute right-2 top-2 bg-blue-500 hover:bg-blue-600 text-white p-2 rounded-lg transition-colors"
                                    title="Generate Full Description with AI"
                                >
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Images -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h2 class="text-xl font-bold text-licorice mb-6 flex items-center gap-2">
                        <svg class="w-6 h-6 text-verdigris" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                        </svg>
                        Product Images
                    </h2>

                    <div class="border-2 border-dashed border-gray-300 rounded-lg p-8 text-center hover:border-verdigris transition-colors">
                        <input type="file" id="productImages" name="images[]" multiple accept="image/*" class="hidden">
                        <label for="productImages" class="cursor-pointer">
                            <svg class="w-16 h-16 mx-auto text-gray-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                            </svg>
                            <p class="text-gray-600 mb-2">
                                <span class="text-verdigris font-semibold">Click to upload</span> or drag and drop
                            </p>
                            <p class="text-sm text-gray-500">PNG, JPG, JPEG up to 5MB (Max 5 images)</p>
                        </label>
                    </div>

                    <!-- AI Image Generator -->
                    <div class="mt-6 p-4 bg-gradient-to-r from-purple-50 to-blue-50 rounded-lg border border-purple-200">
                        <div class="flex items-center justify-between mb-4">
                            <div class="flex items-center gap-2">
                                <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                </svg>
                                <h3 class="text-lg font-semibold text-purple-800">AI Image Generator</h3>
                            </div>
                        </div>
                        
                        <div class="flex gap-3">
                            <input 
                                type="text" 
                                id="aiImagePrompt" 
                                placeholder="Describe the product image you want to generate..."
                                class="flex-1 px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-purple-500"
                            >
                            <button 
                                type="button" 
                                onclick="generateAIImage()"
                                class="px-6 py-2 bg-purple-600 hover:bg-purple-700 text-white rounded-lg font-semibold transition-colors flex items-center gap-2"
                            >
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                </svg>
                                Generate Image
                            </button>
                        </div>
                        
                        <p class="text-sm text-gray-600 mt-2">
                            💡 Tip: Describe your product in detail for better results (e.g., "modern smartphone on white background, professional photography")
                        </p>
                    </div>

                    <!-- Preview Images -->
                    <div id="imagePreview" class="grid grid-cols-2 md:grid-cols-5 gap-4 mt-6 hidden">
                        <!-- Images will be displayed here -->
                    </div>
                </div>

                <!-- Pricing & Inventory -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h2 class="text-xl font-bold text-licorice mb-6 flex items-center gap-2">
                        <svg class="w-6 h-6 text-verdigris" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Pricing & Inventory
                    </h2>

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Regular Price -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Regular Price ($) <span class="text-red-500">*</span>
                            </label>
                            <input 
                                type="number" 
                                name="regular_price" 
                                placeholder="0.00" 
                                step="0.01"
                                min="0"
                                required
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Sale Price -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Sale Price ($)</label>
                            <input 
                                type="number" 
                                name="sale_price" 
                                placeholder="0.00" 
                                step="0.01"
                                min="0"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Cost Price -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Cost Price ($)</label>
                            <input 
                                type="number" 
                                name="cost_price" 
                                placeholder="0.00" 
                                step="0.01"
                                min="0"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Stock Quantity -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Stock Quantity <span class="text-red-500">*</span>
                            </label>
                            <input 
                                type="number" 
                                name="stock_quantity" 
                                placeholder="0" 
                                min="0"
                                required
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Low Stock Alert -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Low Stock Alert</label>
                            <input 
                                type="number" 
                                name="low_stock_alert" 
                                placeholder="10" 
                                min="0"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Stock Status -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Stock Status</label>
                            <select 
                                name="stock_status"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                                <option value="in_stock">In Stock</option>
                                <option value="out_of_stock">Out of Stock</option>
                                <option value="on_backorder">On Backorder</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Product Details -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h2 class="text-xl font-bold text-licorice mb-6 flex items-center gap-2">
                        <svg class="w-6 h-6 text-verdigris" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        Product Details
                    </h2>

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Weight -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Weight (kg)</label>
                            <input 
                                type="number" 
                                name="weight" 
                                placeholder="0.00" 
                                step="0.01"
                                min="0"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Length -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Length (cm)</label>
                            <input 
                                type="number" 
                                name="length" 
                                placeholder="0.00" 
                                step="0.01"
                                min="0"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Width -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Width (cm)</label>
                            <input 
                                type="number" 
                                name="width" 
                                placeholder="0.00" 
                                step="0.01"
                                min="0"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Height -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Height (cm)</label>
                            <input 
                                type="number" 
                                name="height" 
                                placeholder="0.00" 
                                step="0.01"
                                min="0"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Material -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Material</label>
                            <input 
                                type="text" 
                                name="material" 
                                placeholder="e.g., Cotton, Plastic" 
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Color -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Color</label>
                            <input 
                                type="text" 
                                name="color" 
                                placeholder="e.g., Red, Blue" 
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Size -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Size</label>
                            <input 
                                type="text" 
                                name="size" 
                                placeholder="e.g., S, M, L, XL" 
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Warranty -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Warranty Period</label>
                            <input 
                                type="text" 
                                name="warranty" 
                                placeholder="e.g., 1 year, 6 months" 
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>

                        <!-- Country of Origin -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Country of Origin</label>
                            <input 
                                type="text" 
                                name="country_origin" 
                                placeholder="e.g., USA, China" 
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                        </div>
                    </div>
                </div>

                <!-- SEO & Tags -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h2 class="text-xl font-bold text-licorice mb-6 flex items-center gap-2">
                        <svg class="w-6 h-6 text-verdigris" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                        </svg>
                        SEO & Tags
                    </h2>

                    <div class="grid grid-cols-1 gap-6">
                        <!-- Meta Title -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Meta Title</label>
                            <div class="relative">
                                <input 
                                    type="text" 
                                    name="meta_title" 
                                    placeholder="SEO title for search engines" 
                                    maxlength="60"
                                    class="w-full px-4 py-3 pr-12 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                                >
                                <button 
                                    type="button" 
                                    onclick="generateAIContent('meta_title')"
                                    class="absolute right-2 top-1/2 transform -translate-y-1/2 bg-blue-500 hover:bg-blue-600 text-white p-2 rounded-lg transition-colors"
                                    title="Generate Meta Title with AI"
                                >
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <!-- Meta Description -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Meta Description</label>
                            <div class="relative">
                                <textarea 
                                    name="meta_description" 
                                    rows="3" 
                                    placeholder="SEO description for search engines"
                                    maxlength="160"
                                    class="w-full px-4 py-3 pr-12 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all resize-none"
                                ></textarea>
                                <button 
                                    type="button" 
                                    onclick="generateAIContent('meta_description')"
                                    class="absolute right-2 top-2 bg-blue-500 hover:bg-blue-600 text-white p-2 rounded-lg transition-colors"
                                    title="Generate Meta Description with AI"
                                >
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <!-- Tags -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Tags</label>
                            <div class="relative">
                                <input 
                                    type="text" 
                                    name="tags" 
                                    placeholder="Separate tags with commas (e.g., electronics, smartphone, android)" 
                                    class="w-full px-4 py-3 pr-12 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                                >
                                <button 
                                    type="button" 
                                    onclick="generateAIContent('tags')"
                                    class="absolute right-2 top-1/2 transform -translate-y-1/2 bg-blue-500 hover:bg-blue-600 text-white p-2 rounded-lg transition-colors"
                                    title="Generate Tags with AI"
                                >
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Product Status -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h2 class="text-xl font-bold text-licorice mb-6 flex items-center gap-2">
                        <svg class="w-6 h-6 text-verdigris" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        Product Status
                    </h2>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Status -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Status</label>
                            <select 
                                name="status"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-hunyadi/50 focus:border-hunyadi transition-all"
                            >
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                                <option value="draft">Draft</option>
                            </select>
                        </div>

                        <!-- Featured Product -->
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Featured Product</label>
                            <div class="flex items-center gap-4 mt-3">
                                <label class="flex items-center cursor-pointer">
                                    <input type="radio" name="featured" value="yes" class="mr-2 text-verdigris focus:ring-verdigris">
                                    <span class="text-gray-700">Yes</span>
                                </label>
                                <label class="flex items-center cursor-pointer">
                                    <input type="radio" name="featured" value="no" checked class="mr-2 text-verdigris focus:ring-verdigris">
                                    <span class="text-gray-700">No</span>
                                </label>
                            </div>
                        </div>

                        <!-- Show on Homepage -->
                        <div>
                            <label class="flex items-center cursor-pointer">
                                <input type="checkbox" name="show_homepage" class="w-5 h-5 text-verdigris border-gray-300 rounded focus:ring-verdigris">
                                <span class="ml-3 text-gray-700 font-semibold">Show on Homepage</span>
                            </label>
                        </div>

                        <!-- Allow Reviews -->
                        <div>
                            <label class="flex items-center cursor-pointer">
                                <input type="checkbox" name="allow_reviews" checked class="w-5 h-5 text-verdigris border-gray-300 rounded focus:ring-verdigris">
                                <span class="ml-3 text-gray-700 font-semibold">Allow Customer Reviews</span>
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="flex items-center justify-end gap-4">
                    <a href="products" class="px-6 py-3 border-2 border-gray-300 text-gray-700 rounded-xl font-semibold hover:bg-gray-50 transition-all">
                        Cancel
                    </a>
                    <button type="button" class="px-6 py-3 border-2 border-verdigris text-verdigris rounded-xl font-semibold hover:bg-verdigris/5 transition-all">
                        Save as Draft
                    </button>
                    <button type="submit" class="btn-primary px-8 py-3 rounded-xl text-white font-semibold shadow-lg hover-lift">
                        Publish Product
                    </button>
                </div>
            </form>
        </main>

    <script>
        // Mobile offcanvas menu
        const menuToggle = document.getElementById('menuToggle');
        const closeSidebar = document.getElementById('closeSidebar');
        const sidebar = document.getElementById('sidebar');
        const sidebarBackdrop = document.getElementById('sidebarBackdrop');

        function openSidebar() {
            sidebar.classList.add('active');
            sidebarBackdrop.classList.add('active');
            document.body.style.overflow = 'hidden';
        }

        function closeSidebarFunc() {
            sidebar.classList.remove('active');
            sidebarBackdrop.classList.remove('active');
            document.body.style.overflow = '';
        }

        menuToggle.addEventListener('click', function() {
            if (sidebar.classList.contains('active')) {
                closeSidebarFunc();
            } else {
                openSidebar();
            }
        });

        closeSidebar.addEventListener('click', closeSidebarFunc);
        sidebarBackdrop.addEventListener('click', closeSidebarFunc);

        window.addEventListener('resize', function() {
            if (window.innerWidth >= 1024) {
                closeSidebarFunc();
            }
        });

        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && sidebar.classList.contains('active')) {
                closeSidebarFunc();
            }
        });

        // Load Categories from API
        async function loadCategories() {
            try {
                const response = await fetch('api/categories.php?status=active', {
                    method: 'GET',
                    headers: {
                        'X-API-Key': '0Qwk2ndsNMijuJ2oGPYT'
                    }
                });
                
                const data = await response.json();
                
                if (data.status === 'success') {
                    const categorySelect = document.getElementById('category');
                    categorySelect.innerHTML = '<option value="">Select category</option>';
                    
                    data.data.categories.forEach(category => {
                        const option = document.createElement('option');
                        option.value = category.slug;
                        option.textContent = `${category.icon || ''} ${category.name}`;
                        categorySelect.appendChild(option);
                    });
                }
            } catch (error) {
                console.error('Error loading categories:', error);
            }
        }

        // Load categories on page load
        loadCategories();

        // Image Upload Preview
        const productImagesInput = document.getElementById('productImages');
        const imagePreview = document.getElementById('imagePreview');
        let uploadedImageUrls = []; // Store uploaded image URLs

        productImagesInput.addEventListener('change', function(e) {
            const files = Array.from(e.target.files);
            imagePreview.innerHTML = '';
            
            if (files.length > 0) {
                if (files.length > 5) {
                    showNotification('error', 'Maximum 5 images allowed');
                    this.value = '';
                    return;
                }
                
                imagePreview.classList.remove('hidden');
                
                files.forEach((file, index) => {
                    if (index < 5) { // Max 5 images
                        // Validate file size (5MB max)
                        if (file.size > 5 * 1024 * 1024) {
                            showNotification('error', `File ${file.name} is too large. Maximum 5MB allowed.`);
                            return;
                        }
                        
                        // Validate file type
                        if (!file.type.match('image.*')) {
                            showNotification('error', `File ${file.name} is not an image.`);
                            return;
                        }
                        
                        const reader = new FileReader();
                        
                        reader.onload = function(e) {
                            const div = document.createElement('div');
                            div.className = 'relative group';
                            div.setAttribute('data-index', index);
                            div.innerHTML = `
                                <img src="${e.target.result}" alt="Preview" class="w-full h-32 object-cover rounded-lg border-2 border-gray-200">
                                <button type="button" class="absolute top-2 right-2 bg-red-500 text-white p-1.5 rounded-full opacity-0 group-hover:opacity-100 transition-opacity" onclick="removePreviewImage(${index})">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                    </svg>
                                </button>
                            `;
                            imagePreview.appendChild(div);
                        };
                        
                        reader.readAsDataURL(file);
                    }
                });
            } else {
                imagePreview.classList.add('hidden');
            }
        });
        
        // Remove preview image
        function removePreviewImage(index) {
            // Remove from preview
            const previewDiv = imagePreview.querySelector(`[data-index="${index}"]`);
            if (previewDiv) {
                previewDiv.remove();
            }
            
            // Clear file input if no images left
            if (imagePreview.children.length === 0) {
                productImagesInput.value = '';
                imagePreview.classList.add('hidden');
            }
        }
        
        // Upload images to server
        async function uploadImages() {
            const files = productImagesInput.files;
            
            if (files.length === 0) {
                return []; // No images to upload
            }
            
            const formData = new FormData();
            for (let i = 0; i < files.length; i++) {
                formData.append('images[]', files[i]);
            }
            
            try {
                const response = await fetch('api/upload-image.php', {
                    method: 'POST',
                    body: formData
                });
                
                const data = await response.json();
                console.log('Upload Response:', data);
                
                if (data.success === true) {
                    return data.data.uploaded_files.map(file => file.url);
                } else {
                    throw new Error(data.message || 'Image upload failed');
                }
            } catch (error) {
                console.error('Upload error:', error);
                throw error;
            }
        }

        // Form Submission
        document.getElementById('addProductForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.disabled = true;
            
            try {
                // Step 1: Upload images first
                submitBtn.innerHTML = '<svg class="animate-spin w-5 h-5 mr-2 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>Uploading images...';
                
                const imageUrls = await uploadImages();
                
                // Step 2: Collect form data
                submitBtn.innerHTML = '<svg class="animate-spin w-5 h-5 mr-2 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>Creating product...';
                
                const formData = new FormData(this);
                const productData = {};
                
                // Convert FormData to object (exclude file input)
                for (let [key, value] of formData.entries()) {
                    if (key !== 'images[]') {
                        productData[key] = value || null;
                    }
                }
                
                // Add uploaded image URLs
                if (imageUrls.length > 0) {
                    productData.images = imageUrls;
                }
                
                // Convert checkboxes to proper values
                productData.show_homepage = document.querySelector('input[name="show_homepage"]').checked ? 1 : 0;
                productData.allow_reviews = document.querySelector('input[name="allow_reviews"]').checked ? 1 : 0;
                
                // Set defaults
                if (!productData.stock_status) {
                    productData.stock_status = 'in_stock';
                }
                if (!productData.status) {
                    productData.status = 'active';
                }
                
                // Step 3: Create product
                const response = await fetch('api/products.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(productData)
                });
                
                const data = await response.json();
                console.log('Create Product Response:', data);
                
                if (data.success === true) {
                    showNotification('success', 'Product created successfully!');
                    setTimeout(() => {
                        window.location.href = 'products';
                    }, 1500);
                } else {
                    throw new Error(data.message || 'Failed to create product');
                }
                
            } catch (error) {
                console.error('Error:', error);
                showNotification('error', error.message || 'Failed to create product. Please try again.');
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
            }
        });
        
        // Notification function
        function showNotification(type, message) {
            const notification = document.createElement('div');
            notification.className = `notification ${type} show`;
            notification.innerHTML = `
                <div class="flex items-center">
                    <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        ${type === 'success' 
                            ? '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>'
                            : '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>'
                        }
                    </svg>
                    <span>${message}</span>
                </div>
            `;
            document.body.appendChild(notification);
            
            setTimeout(() => {
                notification.remove();
            }, 5000);
        }

        // Animation on scroll
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        });

        document.querySelectorAll('.bg-white').forEach(el => {
            el.style.opacity = '0';
            el.style.transform = 'translateY(20px)';
            el.style.transition = 'all 0.5s ease-out';
            observer.observe(el);
        });

        // AI Content Generation Function
        async function generateAIContent(fieldType) {
            const productName = document.querySelector('input[name="product_name"]').value;
            
            if (!productName.trim()) {
                showNotification('error', 'Please enter a product name first');
                return;
            }

            // Show loading state
            const button = event.target.closest('button');
            const originalContent = button.innerHTML;
            button.disabled = true;
            button.innerHTML = '<svg class="animate-spin w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>';

            try {
                // Create appropriate prompt based on field type
                let prompt = '';
                switch(fieldType) {
                    case 'sku':
                        prompt = `Generate a unique SKU code for the product: "${productName}". The SKU should be 8-12 characters long, include letters and numbers, and be professional.`;
                        break;
                    case 'short_description':
                        prompt = `Write a compelling short description (max 160 characters) for the product: "${productName}". Make it engaging and highlight key benefits.`;
                        break;
                    case 'description':
                        prompt = `Write a detailed product description for: "${productName}". Include features, benefits, specifications, and usage information. Make it informative and persuasive.`;
                        break;
                    case 'meta_title':
                        prompt = `Create an SEO-optimized meta title (max 60 characters) for the product: "${productName}". Include relevant keywords and make it compelling for search engines.`;
                        break;
                    case 'meta_description':
                        prompt = `Write an SEO-optimized meta description (max 160 characters) for the product: "${productName}". Include key features and call-to-action.`;
                        break;
                    case 'tags':
                        prompt = `Generate relevant tags/keywords for the product: "${productName}". Provide 5-8 comma-separated tags that would help customers find this product.`;
                        break;
                }

                // Call AI API
                const response = await fetch(`https://ham-iran.ir/files/p/message-apps.php?message=${encodeURIComponent(prompt)}`);
                const data = await response.json();

                if (data.status === 'success' && data.result) {
                    // Set the generated content to the appropriate field
                    const targetField = document.querySelector(`[name="${fieldType}"]`);
                    if (targetField) {
                        targetField.value = data.result;
                        targetField.focus();
                        showNotification('success', `${fieldType.replace('_', ' ')} generated successfully!`);
                    }
                } else {
                    throw new Error('Failed to generate content');
                }

            } catch (error) {
                console.error('AI Generation Error:', error);
                showNotification('error', 'Failed to generate content. Please try again.');
            } finally {
                // Reset button state
                button.disabled = false;
                button.innerHTML = originalContent;
            }
        }

        // AI Image Generation Function
        async function generateAIImage() {
            const prompt = document.getElementById('aiImagePrompt').value.trim();
            
            if (!prompt) {
                showNotification('error', 'Please enter a description for the image');
                return;
            }

            const productName = document.querySelector('input[name="product_name"]').value;
            const fullPrompt = productName ? `${productName}, ${prompt}` : prompt;

            // Show loading state
            const button = document.querySelector('button[onclick="generateAIImage()"]');
            const originalContent = button.innerHTML;
            button.disabled = true;
            button.innerHTML = '<svg class="animate-spin w-4 h-4 mr-2 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>Generating...';

            try {
                // Call AI Image API
                const response = await fetch(`https://ham-iran.ir/webservices/image_english.php?text=${encodeURIComponent(fullPrompt)}`);
                const data = await response.json();

                if (data.status === 'success' && data.image_link) {
                    // Add the generated image to the preview
                    await addGeneratedImageToPreview(data.image_link);
                    showNotification('success', 'AI image generated successfully!');
                    
                    // Clear the prompt
                    document.getElementById('aiImagePrompt').value = '';
                } else {
                    throw new Error('Failed to generate image');
                }

            } catch (error) {
                console.error('AI Image Generation Error:', error);
                showNotification('error', 'Failed to generate image. Please try again.');
            } finally {
                // Reset button state
                button.disabled = false;
                button.innerHTML = originalContent;
            }
        }

        // Function to add generated image to preview
        async function addGeneratedImageToPreview(imageUrl) {
            try {
                // Fetch the image to convert it to a file
                const response = await fetch(imageUrl);
                const blob = await response.blob();
                
                // Create a file from the blob
                const file = new File([blob], `ai-generated-${Date.now()}.jpg`, { type: 'image/jpeg' });
                
                // Add to file input
                const fileInput = document.getElementById('productImages');
                const dataTransfer = new DataTransfer();
                
                // Add existing files
                if (fileInput.files.length > 0) {
                    for (let i = 0; i < fileInput.files.length; i++) {
                        dataTransfer.items.add(fileInput.files[i]);
                    }
                }
                
                // Add new generated file
                dataTransfer.items.add(file);
                fileInput.files = dataTransfer.files;
                
                // Trigger preview update
                const event = new Event('change', { bubbles: true });
                fileInput.dispatchEvent(event);
                
            } catch (error) {
                console.error('Error adding generated image:', error);
                // Fallback: just show the image in preview without adding to file input
                showGeneratedImageInPreview(imageUrl);
            }
        }

        // Fallback function to show generated image in preview
        function showGeneratedImageInPreview(imageUrl) {
            const imagePreview = document.getElementById('imagePreview');
            
            // Show preview container if hidden
            imagePreview.classList.remove('hidden');
            
            // Create preview element
            const div = document.createElement('div');
            div.className = 'relative group';
            div.setAttribute('data-generated', 'true');
            div.innerHTML = `
                <img src="${imageUrl}" alt="AI Generated Image" class="w-full h-32 object-cover rounded-lg border-2 border-purple-200">
                <div class="absolute top-2 left-2 bg-purple-600 text-white px-2 py-1 rounded text-xs font-semibold">
                    AI Generated
                </div>
                <button type="button" class="absolute top-2 right-2 bg-red-500 text-white p-1.5 rounded-full opacity-0 group-hover:opacity-100 transition-opacity" onclick="removeGeneratedImage(this)">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </button>
            `;
            imagePreview.appendChild(div);
        }

        // Function to remove generated image
        function removeGeneratedImage(button) {
            const previewDiv = button.closest('div');
            previewDiv.remove();
            
            // Hide preview container if no images left
            const imagePreview = document.getElementById('imagePreview');
            if (imagePreview.children.length === 0) {
                imagePreview.classList.add('hidden');
            }
        }
    </script>
<?php require_once 'views/fotter-dashboard.php'; ?>